/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.io.Closeable;
import java.util.Set;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.memory.AllocationManager;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public interface ValueVector
extends Closeable,
Iterable<ValueVector> {
    public static final int MAX_BUFFER_SIZE = AllocationManager.chunkSize();
    public static final int MAX_ROW_COUNT = 65536;
    public static final int MIN_ROW_COUNT = 1;
    public static final String BITS_VECTOR_NAME = "$bits$";
    public static final String OFFSETS_VECTOR_NAME = "$offsets$";
    @Deprecated
    public static final String VALUES_VECTOR_NAME = "$values$";

    public void allocateNew() throws OutOfMemoryException;

    public boolean allocateNewSafe();

    public BufferAllocator getAllocator();

    public void setInitialCapacity(int var1);

    public int getValueCapacity();

    @Override
    public void close();

    public void clear();

    public MaterializedField getField();

    public TransferPair getTransferPair(BufferAllocator var1);

    public TransferPair getTransferPair(String var1, BufferAllocator var2);

    public TransferPair makeTransferPair(ValueVector var1);

    public Accessor getAccessor();

    public Mutator getMutator();

    public FieldReader getReader();

    public UserBitShared.SerializedField getMetadata();

    public int getBufferSize();

    public int getAllocatedSize();

    public int getBufferSizeFor(int var1);

    public DrillBuf[] getBuffers(boolean var1);

    public void load(UserBitShared.SerializedField var1, DrillBuf var2);

    public void copyEntry(int var1, ValueVector var2, int var3);

    public void collectLedgers(Set<AllocationManager.BufferLedger> var1);

    public int getPayloadByteCount(int var1);

    public void exchange(ValueVector var1);

    public void toNullable(ValueVector var1);

    public static interface Mutator {
        public void setValueCount(int var1);

        public void reset();

        @Deprecated
        public void generateTestData(int var1);

        public void exchange(Mutator var1);
    }

    public static interface Accessor {
        public Object getObject(int var1);

        public int getValueCount();

        public boolean isNull(int var1);
    }
}

