/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.UntypedNullHolder;
import org.apache.drill.exec.vector.UntypedReaderImpl;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorOverflowException;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public final class UntypedNullVector
extends BaseDataValueVector
implements FixedWidthVector {
    public static final int VALUE_WIDTH = 0;
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int valueCount;

    public UntypedNullVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return new UntypedReaderImpl();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return 0;
    }

    @Override
    public int getValueCapacity() {
        return 65536;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
    }

    @Override
    public void allocateNew() {
    }

    @Override
    public boolean allocateNewSafe() {
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.valueCount = valueCount;
    }

    @Override
    public void reset() {
    }

    @Override
    public void zeroVector() {
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getValueWidth() {
        return 0;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", (Object)this.field, (Object)metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 0;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.valueCount = valueCount;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((UntypedNullVector)to);
    }

    public void transferTo(UntypedNullVector target) {
        target.valueCount = this.valueCount;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, UntypedNullVector target) {
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return 0;
    }

    public void copyFrom(int fromIndex, int thisIndex, UntypedNullVector from) {
    }

    public void copyFromSafe(int fromIndex, int thisIndex, UntypedNullVector from) {
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
    }

    @Override
    public void clear() {
        this.valueCount = 0;
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return UntypedNullVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            Preconditions.checkElementIndex(index, UntypedNullVector.this.valueCount);
            return true;
        }

        public int isSet(int index) {
            Preconditions.checkElementIndex(index, UntypedNullVector.this.valueCount);
            return 0;
        }

        @Override
        public Object getObject(int index) {
            Preconditions.checkElementIndex(index, UntypedNullVector.this.valueCount);
            return null;
        }

        public void get(int index, UntypedNullHolder holder) {
            Preconditions.checkElementIndex(index, UntypedNullVector.this.valueCount);
        }
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support set");
        }

        public void set(int index, int isSet, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support set");
        }

        public void setSafe(int index, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support setSafe");
        }

        public void setSafe(int index, int isSet, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support setSafe");
        }

        public void setScalar(int index, UntypedNullHolder holder) throws VectorOverflowException {
            throw new UnsupportedOperationException("UntypedNullVector does not support setScalar");
        }

        public void setArrayItem(int index, UntypedNullHolder holder) throws VectorOverflowException {
            throw new UnsupportedOperationException("UntypedNullVector does not support setArrayItem");
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
        }

        @Override
        public void setValueCount(int valueCount) {
            UntypedNullVector.this.valueCount = valueCount;
        }
    }

    private class TransferImpl
    implements TransferPair {
        private final UntypedNullVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new UntypedNullVector(field, allocator);
        }

        public TransferImpl(UntypedNullVector to) {
            this.to = to;
        }

        @Override
        public UntypedNullVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            UntypedNullVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Preconditions.checkPositionIndexes(startIndex, startIndex + length, UntypedNullVector.this.valueCount);
            UntypedNullVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            Preconditions.checkElementIndex(fromIndex, UntypedNullVector.this.valueCount);
            this.to.copyFromSafe(fromIndex, toIndex, UntypedNullVector.this);
        }
    }
}

