/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.RepeatedFloat8Holder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AddOrGetResult;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorDescriptor;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedFloat8ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedFloat8Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private Float8Vector values;
    private final FieldReader reader = new RepeatedFloat8ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedFloat8Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withPrecisionAndScale(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getPrecision(), majorType.getScale())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Float8Vector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedFloat8Vector)to);
    }

    public AddOrGetResult<Float8Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<Float8Vector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedFloat8Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedFloat8Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedFloat8Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedFloat8Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedFloat8Vector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super(RepeatedFloat8Vector.this);
        }

        public void add(int index, double value) {
            int nextOffset = RepeatedFloat8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat8Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedFloat8Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, double srcValue) {
            int nextOffset = RepeatedFloat8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat8Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedFloat8Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedFloat8Holder h) {
            Float8Holder ih = new Float8Holder();
            Float8Vector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedFloat8Vector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedFloat8Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Float8Holder holder) {
            int nextOffset = RepeatedFloat8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat8Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedFloat8Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableFloat8Holder holder) {
            int nextOffset = RepeatedFloat8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat8Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedFloat8Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedFloat8Vector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedFloat8Vector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, Float8Holder holder) {
            int nextOffset = RepeatedFloat8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat8Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedFloat8Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedFloat8Holder holder) {
            Float8Vector.Accessor accessor = holder.vector.getAccessor();
            Float8Holder innerHolder = new Float8Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedFloat8Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedFloat8Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(RepeatedFloat8Vector.this);
        }

        @Override
        public List<Double> getObject(int index) {
            JsonStringArrayList<Double> vals = new JsonStringArrayList<Double>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedFloat8Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Float8Vector.Accessor valuesAccessor = RepeatedFloat8Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Double getSingleObject(int index, int arrayIndex) {
            int start = RepeatedFloat8Vector.this.offsets.getAccessor().get(index);
            return RepeatedFloat8Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public double get(int index, int positionIndex) {
            return RepeatedFloat8Vector.this.values.getAccessor().get(RepeatedFloat8Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedFloat8Holder holder) {
            holder.start = RepeatedFloat8Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedFloat8Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedFloat8Vector.this.values;
            holder.reader = RepeatedFloat8Vector.this.reader;
        }

        public void get(int index, int positionIndex, Float8Holder holder) {
            int offset = RepeatedFloat8Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedFloat8Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableFloat8Holder holder) {
            int offset = RepeatedFloat8Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedFloat8Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedFloat8Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedFloat8Vector(field, allocator);
        }

        public TransferImpl(RepeatedFloat8Vector to) {
            this.to = to;
        }

        @Override
        public RepeatedFloat8Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedFloat8Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedFloat8Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedFloat8Vector.this);
        }
    }
}

