/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Set;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.memory.AllocationManager;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullableTimeStampReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

public final class NullableTimeStampVector
extends BaseDataValueVector
implements FixedWidthVector,
NullableVector {
    private static final int DEFINED_VALUES_ARRAY_LEN = 1024;
    private static final byte[] DEFINED_VALUES_ARRAY = new byte[1024];
    private final FieldReader reader = new NullableTimeStampReaderImpl(this);
    private final UInt1Vector bits = new UInt1Vector(bitsField, this.allocator);
    private final TimeStampVector values = new TimeStampVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableTimeStampVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public int getAllocatedSize() {
        return this.bits.getAllocatedSize() + this.values.getAllocatedSize();
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public TimeStampVector getValuesVector() {
        return this.values;
    }

    @Override
    public UInt1Vector getBitsVector() {
        return this.bits;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
                return false;
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.bits.collectLedgers(ledgers);
        this.values.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.bits.getPayloadByteCount(valueCount) + this.values.getPayloadByteCount(valueCount);
    }

    @Override
    public int getValueWidth() {
        return this.bits.getValueWidth() + 8;
    }

    @Override
    public void allocateNew(int valueCount) {
        try {
            this.values.allocateNew(valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public void zeroVector() {
        this.bits.zeroVector();
        this.values.zeroVector();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableTimeStampVector)to);
    }

    public void transferTo(NullableTimeStampVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableTimeStampVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public TimeStampVector convertToRequiredVector() {
        TimeStampVector v = new TimeStampVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public int getBitsValueCapacity() {
        return this.bits.getValueCapacity();
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableTimeStampVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, TimeStampVector from) {
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableTimeStampVector from) {
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        if (from instanceof TimeStampVector) {
            this.bits.getMutator().setSafe(toIndex, 1);
            this.values.copyFromSafe(fromIndex, toIndex, (TimeStampVector)from);
            return;
        }
        NullableTimeStampVector fromVector = (NullableTimeStampVector)from;
        this.bits.copyFromSafe(fromIndex, toIndex, fromVector.bits);
        this.values.copyFromSafe(fromIndex, toIndex, fromVector.values);
    }

    @Override
    public void exchange(ValueVector other) {
        NullableTimeStampVector target = (NullableTimeStampVector)other;
        this.bits.exchange(target.bits);
        this.values.exchange(target.values);
        this.mutator.exchange(other.getMutator());
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        this.exchange(nullableVector);
        this.clear();
    }

    static {
        Arrays.fill(DEFINED_VALUES_ARRAY, (byte)1);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter,
    NullableVector.Mutator {
        private Mutator() {
        }

        public TimeStampVector getVectorWithValues() {
            return NullableTimeStampVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableTimeStampVector.this.bits.getMutator().set(index, 1);
        }

        @Override
        public void setIndexDefined(int index, int numValues) {
            int batchSz;
            for (int remaining = numValues; remaining > 0; remaining -= batchSz) {
                batchSz = Math.min(remaining, 1024);
                NullableTimeStampVector.this.bits.getMutator().set(index + (numValues - remaining), DEFINED_VALUES_ARRAY, 0, batchSz);
            }
        }

        public void set(int index, long value) {
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableTimeStampVector.this.bits.getMutator();
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
        }

        public void setNull(int index) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, TimeStampHolder holder) {
            NullableTimeStampVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableTimeStampHolder holder) {
            NullableTimeStampVector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableTimeStampHolder holder) {
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            NullableTimeStampVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
        }

        public void set(int index, TimeStampHolder holder) {
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            NullableTimeStampVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableTimeStampVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, long valueField) {
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            NullableTimeStampVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, valueField);
        }

        public void setSafe(int index, int isSet, long valueField) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, isSet);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, valueField);
        }

        public void setSafe(int index, NullableTimeStampHolder value) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, value);
        }

        public void setSafe(int index, TimeStampHolder value) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, 1);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, value);
        }

        public void setSafe(int index, long value) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, 1);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, value);
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableTimeStampVector.this.values.getMutator().setValueCount(valueCount);
            NullableTimeStampVector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableTimeStampVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableTimeStampVector.this.values.getMutator().generateTestData(valueCount);
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
        }

        @Override
        public void setSetCount(int n) {
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
        }

        public void fromNotNullable(TimeStampVector srce) {
            NullableTimeStampVector.this.clear();
            int valueCount = srce.getAccessor().getValueCount();
            BaseValueVector.fillBitsVector(NullableTimeStampVector.this.getBitsVector(), valueCount);
            NullableTimeStampVector.this.getValuesVector().exchange(srce);
            this.setValueCount(valueCount);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final UInt1Vector.Accessor bAccessor;
        final TimeStampVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableTimeStampVector.this.bits.getAccessor();
            this.vAccessor = NullableTimeStampVector.this.values.getAccessor();
        }

        public long get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableTimeStampHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public LocalDateTime getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableTimeStampVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        private final NullableTimeStampVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableTimeStampVector(field, allocator);
        }

        public TransferImpl(NullableTimeStampVector to) {
            this.to = to;
        }

        @Override
        public NullableTimeStampVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableTimeStampVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableTimeStampVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableTimeStampVector.this);
        }
    }
}

