/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryAllocationUtilities {
    private static final Logger logger = LoggerFactory.getLogger(MemoryAllocationUtilities.class);

    public static void setupBufferedMemoryAllocations(PhysicalPlan plan, QueryContext queryContext) {
        MemoryAllocationUtilities.setupBufferedOpsMemoryAllocations(plan.getProperties().hasResourcePlan, MemoryAllocationUtilities.getBufferedOperators(plan.getSortedOperators(), queryContext), queryContext);
    }

    public static List<PhysicalOperator> getBufferedOperators(List<PhysicalOperator> operators, QueryContext queryContext) {
        ArrayList<PhysicalOperator> bufferedOpList = new ArrayList<PhysicalOperator>();
        for (PhysicalOperator op : operators) {
            if (!op.isBufferedOperator(queryContext)) continue;
            bufferedOpList.add(op);
        }
        return bufferedOpList;
    }

    public static void setupBufferedOpsMemoryAllocations(boolean planHasMemory, List<PhysicalOperator> bufferedOperators, QueryContext queryContext) {
        if (planHasMemory || bufferedOperators.isEmpty()) {
            return;
        }
        QueryOptionManager optionManager = queryContext.getOptions();
        long directMemory = DrillConfig.getMaxDirectMemory();
        long maxAllocPerNode = MemoryAllocationUtilities.computeQueryMemory(queryContext.getConfig(), optionManager, directMemory);
        logger.debug("Memory per query per node: {}", (Object)maxAllocPerNode);
        long opMinMem = MemoryAllocationUtilities.computeOperatorMemory(optionManager, maxAllocPerNode, bufferedOperators.size());
        for (PhysicalOperator op : bufferedOperators) {
            long alloc = Math.max(opMinMem, op.getInitialAllocation());
            op.setMaxAllocation(alloc);
        }
    }

    public static long computeOperatorMemory(OptionSet optionManager, long maxAllocPerNode, int opCount) {
        long maxWidth = optionManager.getOption(ExecConstants.MAX_WIDTH_PER_NODE);
        double cpuLoadAverage = optionManager.getOption(ExecConstants.CPU_LOAD_AVERAGE);
        long maxWidthPerNode = ExecConstants.MAX_WIDTH_PER_NODE.computeMaxWidth(cpuLoadAverage, maxWidth);
        long maxOperatorAlloc = maxAllocPerNode / ((long)opCount * maxWidthPerNode);
        logger.debug("Max buffered operator alloc: {}", (Object)maxOperatorAlloc);
        return Math.max(maxOperatorAlloc, optionManager.getOption(ExecConstants.MIN_MEMORY_PER_BUFFERED_OP));
    }

    @VisibleForTesting
    public static long computeQueryMemory(DrillConfig config, OptionSet optionManager, long directMemory) {
        long perQueryMemory = Math.round((double)directMemory * optionManager.getOption(ExecConstants.PERCENT_MEMORY_PER_QUERY));
        perQueryMemory = Math.max(perQueryMemory, optionManager.getOption(ExecConstants.MAX_QUERY_MEMORY_PER_NODE));
        long maxAllocPerNode = Math.min(directMemory, config.getLong("drill.memory.top.max"));
        maxAllocPerNode = Math.min(maxAllocPerNode, perQueryMemory);
        return maxAllocPerNode;
    }
}

