/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.util.SerializationModule;

public class JsonStringHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final ObjectMapper mapper = JacksonUtils.createObjectMapper().registerModule((Module)SerializationModule.getModule()).registerModule((Module)new JodaModule());

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (Object key : this.keySet()) {
            if (this.get(key) == null) {
                if (other.get(key) == null) continue;
                return false;
            }
            if (this.get(key) instanceof byte[]) {
                if (other.get(key) instanceof byte[]) {
                    return Arrays.equals((byte[])this.get(key), (byte[])other.get(key));
                }
                return false;
            }
            if (this.get(key).equals(other.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize hash map to JSON string", e);
        }
    }
}

