/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.testing.store;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.store.sys.BasePersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreMode;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class NoWriteLocalStore<V>
extends BasePersistentStore<V> {
    private final ConcurrentMap<String, V> store = Maps.newConcurrentMap();

    @Override
    public void delete(String key) {
        this.store.remove(key);
    }

    @Override
    public PersistentStoreMode getMode() {
        return PersistentStoreMode.PERSISTENT;
    }

    @Override
    public boolean contains(String key) {
        return this.store.containsKey(key);
    }

    @Override
    public V get(String key) {
        return this.store.get(key);
    }

    @Override
    public void put(String key, V value) {
        this.store.put(key, value);
    }

    @Override
    public boolean putIfAbsent(String key, V value) {
        V old = this.store.putIfAbsent(key, value);
        return old == null;
    }

    @Override
    public Iterator<Map.Entry<String, V>> getRange(int skip, int take) {
        return Iterables.limit(Iterables.skip(this.store.entrySet(), skip), take).iterator();
    }

    @Override
    public void close() {
        this.store.clear();
    }
}

