/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.table.function;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.drill.exec.planner.logical.DrillTable;

public final class TableParamDef {
    private final String name;
    private final Class<?> type;
    private final boolean optional;
    private final BiConsumer<DrillTable, Object> action;

    public static TableParamDef required(String name, Class<?> type, BiConsumer<DrillTable, Object> action) {
        return new TableParamDef(name, type, false, action);
    }

    public static TableParamDef optional(String name, Class<?> type, BiConsumer<DrillTable, Object> action) {
        return new TableParamDef(name, type, true, action);
    }

    private TableParamDef(String name, Class<?> type, boolean optional, BiConsumer<DrillTable, Object> action) {
        this.name = name;
        this.type = type;
        this.optional = optional;
        this.action = action;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void apply(DrillTable drillTable, Object value) {
        if (this.action == null) {
            return;
        }
        this.action.accept(drillTable, value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.optional, this.action);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableParamDef that = (TableParamDef)o;
        return this.optional == that.optional && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.action, that.action);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.optional) {
            builder.append("[");
        }
        builder.append(this.name).append(": ").append(this.type);
        if (this.action != null) {
            builder.append(" (with action)");
        }
        if (this.optional) {
            builder.append("]");
        }
        return builder.toString();
    }
}

