/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.store.provider;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.util.function.CheckedFunction;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreProvider;
import org.apache.drill.exec.store.sys.VersionedPersistentStore;
import org.apache.drill.exec.store.sys.store.provider.BasePersistentStoreProvider;

public class CachingPersistentStoreProvider
extends BasePersistentStoreProvider {
    private final Map<PersistentStoreConfig<?>, PersistentStore<?>> storeCache = new ConcurrentHashMap();
    private final Map<PersistentStoreConfig<?>, VersionedPersistentStore<?>> versionedStoreCache = new ConcurrentHashMap();
    private final PersistentStoreProvider provider;

    public CachingPersistentStoreProvider(PersistentStoreProvider provider) {
        this.provider = provider;
    }

    @Override
    public <V> PersistentStore<V> getOrCreateStore(PersistentStoreConfig<V> config) throws StoreException {
        CheckedFunction function = this.provider::getOrCreateStore;
        return this.storeCache.computeIfAbsent(config, function);
    }

    @Override
    public <V> VersionedPersistentStore<V> getOrCreateVersionedStore(PersistentStoreConfig<V> config) throws StoreException {
        CheckedFunction function = this.provider::getOrCreateVersionedStore;
        return this.versionedStoreCache.computeIfAbsent(config, function);
    }

    @Override
    public void start() throws Exception {
        this.provider.start();
    }

    @Override
    public void close() throws Exception {
        ArrayList<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
        closeables.addAll(this.storeCache.values());
        this.storeCache.clear();
        closeables.addAll(this.versionedStoreCache.values());
        this.versionedStoreCache.clear();
        closeables.add(this.provider);
        AutoCloseables.close(closeables);
    }
}

