/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.pojo.NonNullable;

public class ThreadsIterator
implements Iterator<Object> {
    private boolean beforeFirst = true;
    private final ExecutorFragmentContext context;

    public ThreadsIterator(ExecutorFragmentContext context) {
        this.context = context;
    }

    @Override
    public boolean hasNext() {
        return this.beforeFirst;
    }

    @Override
    public Object next() {
        if (!this.beforeFirst) {
            throw new IllegalStateException();
        }
        this.beforeFirst = false;
        ThreadsInfo threadsInfo = new ThreadsInfo();
        CoordinationProtos.DrillbitEndpoint endpoint = this.context.getEndpoint();
        threadsInfo.hostname = endpoint.getAddress();
        threadsInfo.user_port = endpoint.getUserPort();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        threadsInfo.total_threads = threadMXBean.getPeakThreadCount();
        threadsInfo.busy_threads = threadMXBean.getThreadCount();
        return threadsInfo;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class ThreadsInfo {
        @NonNullable
        public String hostname;
        public long user_port;
        public long total_threads;
        public long busy_threads;
    }
}

