/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.pojo.PojoRecordReader;
import org.apache.drill.exec.store.sys.SystemTable;
import org.apache.drill.exec.store.sys.SystemTableScan;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class SystemTableBatchCreator
implements BatchCreator<SystemTableScan> {
    public ScanBatch getBatch(ExecutorFragmentContext context, SystemTableScan scan, List<RecordBatch> children) throws ExecutionSetupException {
        SystemTable table = scan.getTable();
        Iterator<Object> iterator = table.getIterator(context, scan.getMaxRecordsToRead());
        PojoRecordReader<Object> reader = new PojoRecordReader<Object>(table.getPojoClass(), ImmutableList.copyOf(iterator), scan.getMaxRecordsToRead());
        return new ScanBatch(scan, context, Collections.singletonList(reader));
    }
}

