/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.Iterator;
import org.apache.drill.exec.alias.AliasTarget;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.store.sys.AliasesIterator;
import org.apache.drill.exec.store.sys.BitToUserConnectionIterator;
import org.apache.drill.exec.store.sys.DrillbitIterator;
import org.apache.drill.exec.store.sys.ExtendedOptionIterator;
import org.apache.drill.exec.store.sys.FunctionsIterator;
import org.apache.drill.exec.store.sys.MemoryIterator;
import org.apache.drill.exec.store.sys.OptionIterator;
import org.apache.drill.exec.store.sys.ProfileInfoIterator;
import org.apache.drill.exec.store.sys.ProfileJsonIterator;
import org.apache.drill.exec.store.sys.ThreadsIterator;
import org.apache.drill.exec.store.sys.VersionIterator;

public enum SystemTable implements DrillTableSelection
{
    OPTIONS_OLD("options_old", false, (Class)OptionIterator.OptionValueWrapper.class){

        @Override
        @Deprecated
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new OptionIterator(context, OptionIterator.Mode.SYS_SESS_PUBLIC);
        }
    }
    ,
    OPTIONS("options", false, (Class)ExtendedOptionIterator.ExtendedOptionValueWrapper.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new ExtendedOptionIterator(context, false);
        }
    }
    ,
    INTERNAL_OPTIONS_OLD("internal_options_old", false, (Class)OptionIterator.OptionValueWrapper.class){

        @Override
        @Deprecated
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new OptionIterator(context, OptionIterator.Mode.SYS_SESS_INTERNAL);
        }
    }
    ,
    INTERNAL_OPTIONS("internal_options", false, (Class)ExtendedOptionIterator.ExtendedOptionValueWrapper.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new ExtendedOptionIterator(context, true);
        }
    }
    ,
    BOOT("boot", false, (Class)OptionIterator.OptionValueWrapper.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new OptionIterator(context, OptionIterator.Mode.BOOT);
        }
    }
    ,
    DRILLBITS("drillbits", false, (Class)DrillbitIterator.DrillbitInstance.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new DrillbitIterator(context);
        }
    }
    ,
    VERSION("version", false, (Class)VersionIterator.VersionInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new VersionIterator();
        }
    }
    ,
    MEMORY("memory", true, (Class)MemoryIterator.MemoryInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new MemoryIterator(context);
        }
    }
    ,
    CONNECTIONS("connections", true, (Class)BitToUserConnectionIterator.ConnectionInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new BitToUserConnectionIterator(context);
        }
    }
    ,
    PROFILES("profiles", false, (Class)ProfileInfoIterator.ProfileInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new ProfileInfoIterator(context, maxRecords);
        }
    }
    ,
    PROFILES_JSON("profiles_json", false, (Class)ProfileJsonIterator.ProfileJson.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new ProfileJsonIterator(context, maxRecords);
        }
    }
    ,
    THREADS("threads", true, (Class)ThreadsIterator.ThreadsInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new ThreadsIterator(context);
        }
    }
    ,
    FUNCTIONS("functions", false, (Class)FunctionsIterator.FunctionInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new FunctionsIterator(context);
        }
    }
    ,
    STORAGE_ALIASES("storage_aliases", false, (Class)AliasesIterator.AliasInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new AliasesIterator(context, AliasTarget.STORAGE, maxRecords);
        }
    }
    ,
    TABLE_ALIASES("table_aliases", false, (Class)AliasesIterator.AliasInfo.class){

        @Override
        public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
            return new AliasesIterator(context, AliasTarget.TABLE, maxRecords);
        }
    };

    private final String tableName;
    private final boolean distributed;
    private final Class<?> pojoClass;

    private SystemTable(String tableName, boolean distributed, Class<?> pojoClass) {
        this.tableName = tableName;
        this.distributed = distributed;
        this.pojoClass = pojoClass;
    }

    public Iterator<Object> getIterator(ExecutorFragmentContext context, int maxRecords) {
        throw new UnsupportedOperationException(this.tableName + " must override this method.");
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public Class<?> getPojoClass() {
        return this.pojoClass;
    }

    @Override
    public String digest() {
        return this.toString();
    }
}

