/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.serialization.InstanceSerializer;
import org.apache.drill.exec.store.pojo.NonNullable;
import org.apache.drill.exec.store.sys.ProfileIterator;
import org.apache.drill.shaded.guava.com.google.common.base.Function;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileJsonIterator
extends ProfileIterator {
    static final Logger logger = LoggerFactory.getLogger(ProfileJsonIterator.class);
    private final InstanceSerializer<UserBitShared.QueryProfile> profileSerializer;
    private final Iterator<ProfileJson> itr;

    public ProfileJsonIterator(ExecutorFragmentContext context, int maxRecords) {
        super(context, maxRecords);
        this.profileSerializer = this.profileStoreContext.getProfileStoreConfig().getSerializer();
        this.itr = this.iterateProfileInfoJson();
    }

    @Override
    protected Iterator<Map.Entry<String, UserBitShared.QueryProfile>> getProfiles(int skip, int take) {
        return this.profileStoreContext.getCompletedProfileStore().getRange(skip, take);
    }

    private Iterator<ProfileJson> iterateProfileInfoJson() {
        try {
            return this.transformJson(this.getAuthorizedProfiles(this.queryingUsername, this.isAdmin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return Iterators.singletonIterator(ProfileJson.getDefault());
        }
    }

    private Iterator<ProfileJson> transformJson(Iterator<Map.Entry<String, UserBitShared.QueryProfile>> all) {
        return Iterators.transform(all, new Function<Map.Entry<String, UserBitShared.QueryProfile>, ProfileJson>(){

            @Override
            @Nullable
            public ProfileJson apply(@Nullable Map.Entry<String, UserBitShared.QueryProfile> input) {
                String profileJson;
                if (input == null || input.getValue() == null) {
                    return ProfileJson.getDefault();
                }
                String queryID = input.getKey();
                try {
                    profileJson = new String(ProfileJsonIterator.this.profileSerializer.serialize(input.getValue()));
                }
                catch (IOException e) {
                    logger.debug("Failed to serialize profile for: " + queryID, (Throwable)e);
                    profileJson = "{ 'message' : 'error (unable to serialize profile: " + queryID + ")' }";
                }
                return new ProfileJson(queryID, profileJson);
            }
        });
    }

    @Override
    public boolean hasNext() {
        return this.itr.hasNext();
    }

    @Override
    public Object next() {
        return this.itr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class ProfileJson {
        private static final String UNKNOWN_VALUE = "N/A";
        private static final ProfileJson DEFAULT = new ProfileJson();
        @NonNullable
        public final String queryId;
        public final String json;

        public ProfileJson(String query_id, String profileJson) {
            this.queryId = query_id;
            this.json = profileJson;
        }

        private ProfileJson() {
            this(UNKNOWN_VALUE, UNKNOWN_VALUE);
        }

        public static ProfileJson getDefault() {
            return DEFAULT;
        }
    }
}

