/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.QueryProfileStoreContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.util.ImpersonationUtil;

public abstract class ProfileIterator
implements Iterator<Object> {
    private static final int DEFAULT_NUMBER_OF_PROFILES_TO_FETCH = 4000;
    protected final QueryProfileStoreContext profileStoreContext;
    protected final String queryingUsername;
    protected final boolean isAdmin;
    private final int maxRecords;

    protected ProfileIterator(ExecutorFragmentContext context, int maxRecords) {
        this.profileStoreContext = context.getProfileStoreContext();
        this.queryingUsername = context.getQueryUserName();
        this.isAdmin = this.hasAdminPrivileges(context);
        this.maxRecords = maxRecords;
    }

    protected Iterator<Map.Entry<String, UserBitShared.QueryProfile>> getAuthorizedProfiles(String username, boolean isAdministrator) {
        if (this.maxRecords == 0) {
            return Collections.emptyIterator();
        }
        if (isAdministrator) {
            return this.getProfiles(0, this.maxRecords);
        }
        LinkedList<Map.Entry<String, UserBitShared.QueryProfile>> authorizedProfiles = new LinkedList<Map.Entry<String, UserBitShared.QueryProfile>>();
        int skip = 0;
        int take = Math.max(this.maxRecords, 4000);
        while (skip < Integer.MAX_VALUE) {
            Iterator<Map.Entry<String, UserBitShared.QueryProfile>> profiles = this.getProfiles(skip, take);
            int fetchedProfilesCount = 0;
            while (profiles.hasNext()) {
                ++fetchedProfilesCount;
                Map.Entry<String, UserBitShared.QueryProfile> profileKVPair = profiles.next();
                if (!profileKVPair.getValue().getUser().equals(username)) continue;
                authorizedProfiles.add(profileKVPair);
                if (authorizedProfiles.size() != this.maxRecords) continue;
                return authorizedProfiles.iterator();
            }
            if (fetchedProfilesCount != take) {
                return authorizedProfiles.iterator();
            }
            try {
                skip = Math.addExact(skip, take);
            }
            catch (ArithmeticException e) {
                return authorizedProfiles.iterator();
            }
        }
        return authorizedProfiles.iterator();
    }

    protected long computeDuration(long startTime, long endTime) {
        if (endTime > startTime && startTime > 0L) {
            return endTime - startTime;
        }
        return 0L;
    }

    protected abstract Iterator<Map.Entry<String, UserBitShared.QueryProfile>> getProfiles(int var1, int var2);

    private boolean hasAdminPrivileges(ExecutorFragmentContext context) {
        OptionManager options = context.getOptions();
        return !context.isUserAuthenticationEnabled() || ImpersonationUtil.hasAdminPrivileges(context.getQueryUserName(), ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(options), ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(options));
    }
}

