/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.typesafe.config.ConfigException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.store.sys.PersistentStoreProvider;
import org.apache.drill.exec.store.sys.store.provider.CachingPersistentStoreProvider;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentStoreRegistry<C extends ClusterCoordinator> {
    static final Logger logger = LoggerFactory.getLogger(PersistentStoreRegistry.class);
    private final DrillConfig config;
    private final C coordinator;

    public PersistentStoreRegistry(C coordinator, DrillConfig config) {
        this.coordinator = (ClusterCoordinator)Preconditions.checkNotNull(coordinator, "coordinator cannot be null");
        this.config = Preconditions.checkNotNull(config, "config cannot be null");
    }

    public C getCoordinator() {
        return this.coordinator;
    }

    public DrillConfig getConfig() {
        return this.config;
    }

    public PersistentStoreProvider newPStoreProvider() throws ExecutionSetupException {
        try {
            String storeProviderClassName = this.config.getString("drill.exec.sys.store.provider.class");
            logger.info("Using the configured PStoreProvider class: '{}'.", (Object)storeProviderClassName);
            Class<?> storeProviderClass = Class.forName(storeProviderClassName);
            Constructor<?> c = storeProviderClass.getConstructor(PersistentStoreRegistry.class);
            return new CachingPersistentStoreProvider((PersistentStoreProvider)c.newInstance(this));
        }
        catch (ConfigException.Missing | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage(), e);
            throw new ExecutionSetupException("A System Table provider was either not specified or could not be found or instantiated", e);
        }
    }
}

