/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.server.options.DrillConfigIterator;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.pojo.NonNullable;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class OptionIterator
implements Iterator<Object> {
    private final OptionManager fragmentOptions;
    private final Iterator<OptionValue> mergedOptions;

    public OptionIterator(FragmentContext context, Mode mode) {
        Iterator<OptionValue> optionList;
        DrillConfigIterator configOptions = new DrillConfigIterator(context.getConfig());
        this.fragmentOptions = context.getOptions();
        switch (mode) {
            case BOOT: {
                optionList = configOptions.iterator();
                break;
            }
            case SYS_SESS_PUBLIC: {
                optionList = this.fragmentOptions.getPublicOptionList().iterator();
                break;
            }
            case SYS_SESS_INTERNAL: {
                optionList = this.fragmentOptions.getInternalOptionList().iterator();
                break;
            }
            default: {
                optionList = Iterators.concat(configOptions.iterator(), this.fragmentOptions.iterator());
            }
        }
        ArrayList<OptionValue> values = Lists.newArrayList(optionList);
        Collections.sort(values);
        this.mergedOptions = values.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.mergedOptions.hasNext();
    }

    @Override
    public OptionValueWrapper next() {
        OptionValue def;
        OptionValue value = this.mergedOptions.next();
        Status status = value.accessibleScopes == OptionValue.AccessibleScopes.BOOT ? Status.BOOT : (value.equalsIgnoreType(def = this.fragmentOptions.getDefault(value.name)) ? Status.DEFAULT : Status.CHANGED);
        return new OptionValueWrapper(value.name, value.kind, value.accessibleScopes, value.scope, value.num_val, value.string_val, value.bool_val, value.float_val, status);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static enum Mode {
        BOOT,
        SYS_SESS_PUBLIC,
        SYS_SESS_INTERNAL;

    }

    public static enum Status {
        BOOT,
        DEFAULT,
        CHANGED;

    }

    public static class OptionValueWrapper {
        @NonNullable
        public final String name;
        @NonNullable
        public final OptionValue.Kind kind;
        @NonNullable
        public final OptionValue.AccessibleScopes accessibleScopes;
        @NonNullable
        public final OptionValue.OptionScope optionScope;
        @NonNullable
        public final Status status;
        public final Long num_val;
        public final String string_val;
        public final Boolean bool_val;
        public final Double float_val;

        public OptionValueWrapper(String name, OptionValue.Kind kind, OptionValue.AccessibleScopes type, OptionValue.OptionScope scope, Long num_val, String string_val, Boolean bool_val, Double float_val, Status status) {
            this.name = name;
            this.kind = kind;
            this.accessibleScopes = type;
            this.optionScope = scope;
            this.num_val = num_val;
            this.string_val = string_val;
            this.bool_val = bool_val;
            this.float_val = float_val;
            this.status = status;
        }
    }
}

