/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.pojo.NonNullable;

public class MemoryIterator
implements Iterator<Object> {
    private boolean beforeFirst = true;
    private final ExecutorFragmentContext context;

    public MemoryIterator(ExecutorFragmentContext context) {
        this.context = context;
    }

    @Override
    public boolean hasNext() {
        return this.beforeFirst;
    }

    @Override
    public Object next() {
        if (!this.beforeFirst) {
            throw new IllegalStateException();
        }
        this.beforeFirst = false;
        MemoryInfo memoryInfo = new MemoryInfo();
        CoordinationProtos.DrillbitEndpoint endpoint = this.context.getEndpoint();
        memoryInfo.hostname = endpoint.getAddress();
        memoryInfo.user_port = endpoint.getUserPort();
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        memoryInfo.heap_current = heapMemoryUsage.getUsed();
        memoryInfo.heap_max = heapMemoryUsage.getMax();
        BufferPoolMXBean directBean = this.getDirectBean();
        memoryInfo.jvm_direct_current = directBean.getMemoryUsed();
        memoryInfo.direct_current = this.context.getRootAllocator().getAllocatedMemory();
        memoryInfo.direct_max = DrillConfig.getMaxDirectMemory();
        return memoryInfo;
    }

    private BufferPoolMXBean getDirectBean() {
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean b : pools) {
            if (!b.getName().equals("direct")) continue;
            return b;
        }
        throw new IllegalStateException("Unable to find direct buffer bean.  JVM must be too old.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class MemoryInfo {
        @NonNullable
        public String hostname;
        public long user_port;
        public long heap_current;
        public long heap_max;
        public long direct_current;
        public long jvm_direct_current;
        public long direct_max;
    }
}

