/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.expr.fn.registry.FunctionHolder;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.store.pojo.NonNullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsIterator
implements Iterator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(FunctionsIterator.class);
    private final Iterator<FunctionInfo> sortedIterator;

    public FunctionsIterator(ExecutorFragmentContext context) {
        HashMap<String, FunctionInfo> functionMap = new HashMap<String, FunctionInfo>();
        FunctionLookupContext functionLookupContext = context.getFunctionRegistry();
        if (functionLookupContext instanceof FunctionImplementationRegistry) {
            FunctionImplementationRegistry functionImplRegistry = (FunctionImplementationRegistry)functionLookupContext;
            Map<String, List<FunctionHolder>> jarFunctionListMap = functionImplRegistry.getAllJarsWithFunctionsHolders();
            for (String jarName : jarFunctionListMap.keySet()) {
                for (FunctionHolder dfhEntry : jarFunctionListMap.get(jarName)) {
                    this.populateFunctionMap(functionMap, jarName, dfhEntry.getHolder());
                }
            }
            ArrayList functionList = new ArrayList(functionMap.values());
            functionList.sort((o1, o2) -> {
                int result = o1.name.compareTo(o2.name);
                if (result == 0) {
                    result = o1.signature.compareTo(o2.signature);
                }
                if (result == 0) {
                    return o1.returnType.compareTo(o2.returnType);
                }
                return result;
            });
            this.sortedIterator = functionList.iterator();
        } else {
            logger.error("Function Registry was found to be of {} instead of {}. No functions could be loaded ", FunctionImplementationRegistry.class, functionLookupContext.getClass());
            this.sortedIterator = Collections.emptyIterator();
        }
    }

    private void populateFunctionMap(Map<String, FunctionInfo> functionMap, String jarName, DrillFuncHolder dfh) {
        String[] registeredNames = dfh.getRegisteredNames();
        String signature = dfh.getInputParameters();
        String returnType = dfh.getReturnType().getMinorType().toString();
        boolean isInternal = dfh.isInternal();
        for (String name : registeredNames) {
            String funcSignatureKey = new StringBuilder(64).append(name).append('#').append(signature).toString();
            functionMap.put(funcSignatureKey, new FunctionInfo(name, signature, returnType, jarName, isInternal));
        }
    }

    @Override
    public boolean hasNext() {
        return this.sortedIterator.hasNext();
    }

    @Override
    public FunctionInfo next() {
        return this.sortedIterator.next();
    }

    public static class FunctionInfo {
        @NonNullable
        public final String name;
        @NonNullable
        public final String signature;
        @NonNullable
        public final String returnType;
        @NonNullable
        public final String source;
        @NonNullable
        public final boolean internal;

        public FunctionInfo(String funcName, String funcSignature, String funcReturnType, String jarName) {
            this(funcName, funcSignature, funcReturnType, jarName, false);
        }

        public FunctionInfo(String funcName, String funcSignature, String funcReturnType, String jarName, boolean isInternal) {
            this.name = funcName;
            this.signature = funcSignature;
            this.returnType = funcReturnType;
            this.source = jarName;
            this.internal = isInternal;
        }
    }
}

