/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.pojo.NonNullable;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ExtendedOptionIterator
implements Iterator<Object> {
    private final OptionManager fragmentOptions;
    private final Iterator<OptionValue> mergedOptions;
    private final Map<OptionValue.Kind, String> typeMapping;
    private static final int SHORT_DESCRIP_MAX_SIZE = 110;

    public ExtendedOptionIterator(FragmentContext context, boolean internal) {
        this.fragmentOptions = context.getOptions();
        this.typeMapping = new HashMap<OptionValue.Kind, String>();
        this.typeMapping.put(OptionValue.Kind.STRING, "VARCHAR");
        this.typeMapping.put(OptionValue.Kind.DOUBLE, "FLOAT");
        this.typeMapping.put(OptionValue.Kind.LONG, "BIGINT");
        this.typeMapping.put(OptionValue.Kind.BOOLEAN, "BIT");
        this.mergedOptions = !internal ? this.sortOptions(this.fragmentOptions.getPublicOptionList().iterator()) : this.sortOptions(this.fragmentOptions.getInternalOptionList().iterator());
    }

    public Iterator<OptionValue> sortOptions(Iterator<OptionValue> options) {
        ArrayList<OptionValue> optionslist = Lists.newArrayList(options);
        HashMap<String, OptionValue> optionsmap = new HashMap<String, OptionValue>();
        for (OptionValue option : optionslist) {
            if (option.scope == OptionValue.OptionScope.QUERY) continue;
            if (optionsmap.containsKey(option.getName())) {
                if (option.scope.compareTo(((OptionValue)optionsmap.get((Object)option.getName())).scope) <= 0) continue;
                optionsmap.put(option.getName(), option);
                continue;
            }
            optionsmap.put(option.getName(), option);
        }
        optionslist.clear();
        for (String name : optionsmap.keySet()) {
            optionslist.add((OptionValue)optionsmap.get(name));
        }
        optionslist.sort(Comparator.comparing(OptionValue::getName));
        return optionslist.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.mergedOptions.hasNext();
    }

    @Override
    public ExtendedOptionValueWrapper next() {
        OptionValue def;
        OptionValue value = this.mergedOptions.next();
        Status status = value.accessibleScopes == OptionValue.AccessibleScopes.BOOT ? Status.BOOT : (value.equalsIgnoreType(def = this.fragmentOptions.getDefault(value.name)) ? Status.DEFAULT : Status.CHANGED);
        return new ExtendedOptionValueWrapper(value.name, this.typeMapping.get((Object)value.kind), value.accessibleScopes, value.getValue().toString(), status, value.scope, this.getShortDescription(value.name));
    }

    private String getShortDescription(String name) {
        String description;
        OptionValidator.OptionDescription optionDescription = this.fragmentOptions.getOptionDefinition(name).getValidator().getOptionDescription();
        if (optionDescription == null) {
            return "";
        }
        if (optionDescription.hasShortDescription()) {
            description = optionDescription.getShortDescription();
        } else {
            description = optionDescription.getDescription();
            if (description.length() > 110) {
                return description.substring(0, 107).concat("...");
            }
        }
        return description;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static enum Status {
        BOOT,
        DEFAULT,
        CHANGED;

    }

    public static class ExtendedOptionValueWrapper {
        @NonNullable
        public final String name;
        @NonNullable
        public final String kind;
        @NonNullable
        public final OptionValue.AccessibleScopes accessibleScopes;
        public final String val;
        public final Status status;
        @NonNullable
        public final OptionValue.OptionScope optionScope;
        public final String description;

        public ExtendedOptionValueWrapper(String name, String kind, OptionValue.AccessibleScopes type, String value, Status status, OptionValue.OptionScope scope, String description) {
            this.name = name;
            this.kind = kind;
            this.accessibleScopes = type;
            this.val = value;
            this.status = status;
            this.optionScope = scope;
            this.description = description;
        }
    }
}

