/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.alias.AliasTarget;
import org.apache.drill.exec.alias.Aliases;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.pojo.NonNullable;

public class AliasesIterator
implements Iterator<Object> {
    private final Iterator<AliasInfo> iterator;

    public AliasesIterator(FragmentContext context, AliasTarget aliasTarget, int maxRecords) {
        AliasRegistry storageAliasesRegistry;
        switch (aliasTarget) {
            case STORAGE: {
                storageAliasesRegistry = context.getAliasRegistryProvider().getStorageAliasesRegistry();
                break;
            }
            case TABLE: {
                storageAliasesRegistry = context.getAliasRegistryProvider().getTableAliasesRegistry();
                break;
            }
            default: {
                this.iterator = Collections.emptyIterator();
                return;
            }
        }
        Iterable allAliases = storageAliasesRegistry::getAllAliases;
        this.iterator = StreamSupport.stream(allAliases.spliterator(), false).flatMap(aliasesTable -> StreamSupport.stream(this.getAllAliases((Map.Entry<String, Aliases>)aliasesTable).spliterator(), false).map(entry -> this.getAliasInfo((String)entry.getKey(), (String)entry.getValue(), (String)aliasesTable.getKey()))).limit(maxRecords).iterator();
    }

    private AliasInfo getAliasInfo(String alias, String value, String key) {
        boolean isPublic = key.equals("$public_aliases");
        return new AliasInfo(alias, value, isPublic ? null : key, isPublic);
    }

    private Iterable<Map.Entry<String, String>> getAllAliases(Map.Entry<String, Aliases> aliasesTable) {
        return () -> ((Aliases)aliasesTable.getValue()).getAllAliases();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public AliasInfo next() {
        return this.iterator.next();
    }

    public static class AliasInfo {
        @NonNullable
        public final String alias;
        @NonNullable
        public final String name;
        @NonNullable
        public final String user;
        @NonNullable
        public final boolean isPublic;

        public AliasInfo(String alias, String name, String user, boolean isPublic) {
            this.name = name;
            this.alias = alias;
            this.user = user;
            this.isPublic = isPublic;
        }
    }
}

