/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.security.vault;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.response.AuthResponse;
import com.bettercloud.vault.response.LogicalResponse;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.OptBoolean;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultCredentialsProvider
implements CredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(VaultCredentialsProvider.class);
    public static final String VAULT_ADDRESS = "drill.exec.storage.vault.address";
    public static final String VAULT_APP_ROLE_ID = "drill.exec.storage.vault.app_role_id";
    public static final String VAULT_SECRET_ID = "drill.exec.storage.vault.secret_id";
    public static final String QUERY_USER_VAR = "$user";
    private final String secretPath;
    private final String appRoleId;
    private final String secretId;
    private final Map<String, String> propertyNames;
    private final VaultConfig vaultConfig;
    private Vault vault;

    @JsonCreator
    public VaultCredentialsProvider(@JsonProperty(value="secretPath") String secretPath, @JsonProperty(value="propertyNames") Map<String, String> propertyNames, @JacksonInject(useInput=OptBoolean.FALSE) DrillConfig config) throws VaultException {
        this.propertyNames = propertyNames;
        this.secretPath = secretPath;
        this.appRoleId = Objects.requireNonNull(config.getString(VAULT_APP_ROLE_ID), String.format("Vault app role id is not specified. Please set [%s] config property.", VAULT_APP_ROLE_ID));
        this.secretId = Objects.requireNonNull(config.getString(VAULT_SECRET_ID), String.format("Vault secret id is not specified. Please set [%s] config property.", VAULT_SECRET_ID));
        String vaultAddress = Objects.requireNonNull(config.getString(VAULT_ADDRESS), String.format("Vault address is not specified. Please set [%s] config property.", VAULT_ADDRESS));
        this.vaultConfig = new VaultConfig().address(vaultAddress).build();
        this.vault = new Vault(this.vaultConfig);
    }

    private Map<String, String> extractCredentials(Map<String, String> vaultSecrets) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.propertyNames.entrySet()) {
            String cred = vaultSecrets.get(entry.getValue());
            if (cred == null) continue;
            credentials.put(entry.getKey(), vaultSecrets.get(entry.getValue()));
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCredentialsAt(String path) {
        Vault threadVault = this.vault;
        try {
            logger.debug("Attempting to fetch secrets from Vault path {}.", (Object)path);
            LogicalResponse resp = threadVault.logical().read(path);
            if (resp.getRestResponse().getStatus() == 403) {
                logger.info("Attempt to fetch secrets received HTTP 403 from Vault.");
                VaultCredentialsProvider vaultCredentialsProvider = this;
                synchronized (vaultCredentialsProvider) {
                    if (threadVault == this.vault) {
                        logger.info("Attempting to reauthenticate.");
                        AuthResponse authResp = this.vault.auth().loginByAppRole(this.appRoleId, this.secretId);
                        this.vault = new Vault(this.vaultConfig.token(authResp.getAuthClientToken()));
                    } else {
                        logger.debug("Another caller has already attempted reauthentication.");
                    }
                }
                logger.debug("Reattempting to fetch secrets from Vault path {}", (Object)path);
                resp = this.vault.logical().read(path);
            }
            return this.extractCredentials(resp.getData());
        }
        catch (VaultException ex) {
            throw UserException.systemError(ex).message("Error while fetching credentials from vault", new Object[0]).build(logger);
        }
    }

    @Override
    public Map<String, String> getCredentials() {
        Map<String, String> creds = this.getCredentialsAt(this.secretPath);
        if (creds.isEmpty()) {
            logger.warn("No credentials matching the configured property names were readable at {}", (Object)this.secretPath);
        }
        return creds;
    }

    @Override
    public Map<String, String> getUserCredentials(String queryUser) {
        String resolvedPath = this.secretPath.replace(QUERY_USER_VAR, queryUser);
        Map<String, String> creds = this.getCredentialsAt(resolvedPath);
        if (creds.isEmpty()) {
            logger.warn("No credentials for {} matching the configured property names were readable at {}", (Object)queryUser, (Object)resolvedPath);
        }
        return creds;
    }

    public String getSecretPath() {
        return this.secretPath;
    }

    public Map<String, String> getPropertyNames() {
        return this.propertyNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultCredentialsProvider that = (VaultCredentialsProvider)o;
        return Objects.equals(this.secretPath, that.secretPath) && Objects.equals(this.propertyNames, that.propertyNames);
    }

    public int hashCode() {
        return Objects.hash(this.secretPath, this.propertyNames);
    }
}

