/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.security.oauth;

import java.util.Map;
import java.util.Optional;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;

public class OAuthTokenCredentials
extends UsernamePasswordCredentials {
    public static final String CLIENT_ID = "clientID";
    public static final String CLIENT_SECRET = "clientSecret";
    public static final String ACCESS_TOKEN = "accessToken";
    public static final String EXPIRES_IN = "expiresIn";
    public static final String REFRESH_TOKEN = "refreshToken";
    public static final String TOKEN_URI = "tokenURI";
    public static final String PROXY_USERNAME = "proxyUsername";
    public static final String PROXY_PASSWORD = "proxyPassword";
    private final String clientID;
    private final String clientSecret;
    private final String tokenURI;
    private Optional<PersistentTokenTable> tokenTable;

    public OAuthTokenCredentials(String username, String password, String clientID, String clientSecret, String tokenURI, PersistentTokenTable tokenTable) {
        super(username, password);
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.tokenURI = tokenURI;
        this.tokenTable = Optional.ofNullable(tokenTable);
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAccessToken() {
        return this.tokenTable.map(PersistentTokenTable::getAccessToken).orElse(null);
    }

    public String getRefreshToken() {
        return this.tokenTable.map(PersistentTokenTable::getRefreshToken).orElse(null);
    }

    public String getExpiresIn() {
        return this.tokenTable.map(PersistentTokenTable::getExpiresIn).orElse(null);
    }

    public String getTokenUri() {
        return this.tokenURI;
    }

    public static class Builder {
        private CredentialsProvider credentialsProvider;
        private String queryUser;
        private PersistentTokenTable tokenTable;

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder setQueryUser(String queryUser) {
            this.queryUser = queryUser;
            return this;
        }

        public Builder setTokenTable(PersistentTokenTable tokenTable) {
            this.tokenTable = tokenTable;
            return this;
        }

        public Optional<OAuthTokenCredentials> build() {
            Map<String, String> credentials;
            if (this.credentialsProvider == null) {
                return Optional.empty();
            }
            Map<String, String> map = credentials = this.queryUser != null ? this.credentialsProvider.getUserCredentials(this.queryUser) : this.credentialsProvider.getCredentials();
            if (credentials.size() == 0) {
                return Optional.empty();
            }
            return Optional.of(new OAuthTokenCredentials(credentials.get("username"), credentials.get("password"), credentials.get(OAuthTokenCredentials.CLIENT_ID), credentials.get(OAuthTokenCredentials.CLIENT_SECRET), credentials.get(OAuthTokenCredentials.TOKEN_URI), this.tokenTable));
        }
    }
}

