/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.security;

import java.util.Map;
import java.util.Optional;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;

public class UsernamePasswordWithProxyCredentials
extends UsernamePasswordCredentials {
    private final String proxyUsername;
    private final String proxyPassword;

    public UsernamePasswordWithProxyCredentials(String username, String password, String proxyUsername, String proxyPassword) {
        super(username, password);
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public static class Builder {
        private CredentialsProvider credentialsProvider;
        private String queryUser;

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder setQueryUser(String queryUser) {
            this.queryUser = queryUser;
            return this;
        }

        public Optional<UsernamePasswordWithProxyCredentials> build() {
            Map<String, String> credentials;
            if (this.credentialsProvider == null) {
                return Optional.empty();
            }
            Map<String, String> map = credentials = this.queryUser != null ? this.credentialsProvider.getUserCredentials(this.queryUser) : this.credentialsProvider.getCredentials();
            if (credentials.size() == 0) {
                return Optional.empty();
            }
            return Optional.of(new UsernamePasswordWithProxyCredentials(credentials.get("username"), credentials.get("password"), credentials.get("proxyUsername"), credentials.get("proxyPassword")));
        }
    }
}

