/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.logical.security.CredentialsProvider;

public class EnvCredentialsProvider
implements CredentialsProvider {
    private final Map<String, String> envVariables;

    @JsonCreator
    public EnvCredentialsProvider(@JsonProperty(value="envVariableNames") Map<String, String> envVariableNames) {
        this.envVariables = envVariableNames;
    }

    @Override
    public Map<String, String> getCredentials() {
        HashMap<String, String> credentials = new HashMap<String, String>();
        this.envVariables.forEach((key, value) -> {
            String cred = System.getenv(value);
            if (cred != null) {
                credentials.put((String)key, cred);
            }
        });
        return credentials;
    }

    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvCredentialsProvider that = (EnvCredentialsProvider)o;
        return Objects.equals(this.envVariables, that.envVariables);
    }

    public int hashCode() {
        return Objects.hash(this.envVariables);
    }
}

