/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.schedule;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompleteFileWork
implements FileWork,
CompleteWork {
    static final Logger logger = LoggerFactory.getLogger(CompleteFileWork.class);
    private long start;
    private long length;
    private Path path;
    private EndpointByteMap byteMap;

    public CompleteFileWork(EndpointByteMap byteMap, long start, long length, Path path) {
        this.start = start;
        this.length = length;
        this.path = path;
        this.byteMap = byteMap;
    }

    @Override
    public int compareTo(CompleteWork o) {
        if (o instanceof CompleteFileWork) {
            CompleteFileWork c = (CompleteFileWork)o;
            int cmp = this.path.compareTo(c.getPath());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Long.compare(this.start, c.getStart());
            if (cmp != 0) {
                return cmp;
            }
        }
        return Long.compare(this.getTotalBytes(), o.getTotalBytes());
    }

    @Override
    public long getTotalBytes() {
        return this.length;
    }

    @Override
    public EndpointByteMap getByteMap() {
        return this.byteMap;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public FileWorkImpl getAsFileWork() {
        return new FileWorkImpl(this.start, this.length, this.path);
    }

    public String toString() {
        return String.format("File: %s start: %d length: %d", this.path, this.start, this.length);
    }

    public static class FileWorkImpl
    implements FileWork {
        private long start;
        private long length;
        private Path path;

        @JsonCreator
        public FileWorkImpl(@JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="path") Path path) {
            this.start = start;
            this.length = length;
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        public String toString() {
            return "FileWorkImpl{start=" + this.start + ", length=" + this.length + ", path=" + this.path + '}';
        }
    }
}

