/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.schedule;

import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.apache.drill.shaded.guava.com.google.common.collect.ListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentCreator<T extends CompleteWork> {
    static final Logger logger = LoggerFactory.getLogger(AssignmentCreator.class);
    private static Comparator<Map.Entry<CoordinationProtos.DrillbitEndpoint, Long>> comparator = new Comparator<Map.Entry<CoordinationProtos.DrillbitEndpoint, Long>>(){

        @Override
        public int compare(Map.Entry<CoordinationProtos.DrillbitEndpoint, Long> o1, Map.Entry<CoordinationProtos.DrillbitEndpoint, Long> o2) {
            long ret = o1.getValue() - o2.getValue();
            return ret > 0L ? 1 : (ret < 0L ? -1 : 0);
        }
    };
    private int maxWork;
    private final List<T> units;
    private final ArrayListMultimap<Integer, T> mappings = ArrayListMultimap.create();
    private final List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints;

    private AssignmentCreator(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints, List<T> units) {
        this.incomingEndpoints = incomingEndpoints;
        this.units = units;
    }

    public static <T extends CompleteWork> ListMultimap<Integer, T> getMappings(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints, List<T> units) {
        AssignmentCreator<T> creator = new AssignmentCreator<T>(incomingEndpoints, units);
        return super.getMappings();
    }

    private ListMultimap<Integer, T> getMappings() {
        Stopwatch watch = Stopwatch.createStarted();
        this.maxWork = (int)Math.ceil((float)this.units.size() / (float)this.incomingEndpoints.size());
        LinkedList<WorkEndpointListPair<T>> workList = this.getWorkList();
        Map<CoordinationProtos.DrillbitEndpoint, FragIteratorWrapper> endpointIterators = this.getEndpointIterators();
        LinkedList<WorkEndpointListPair<T>> unassignedWorkList = this.assign(workList, endpointIterators, false);
        this.assignLeftovers(unassignedWorkList, endpointIterators, true);
        unassignedWorkList = this.assign(unassignedWorkList, endpointIterators, true);
        this.assignLeftovers(unassignedWorkList, endpointIterators, false);
        if (unassignedWorkList.size() != 0) {
            throw new DrillRuntimeException("There are still unassigned work units");
        }
        logger.debug("Took {} ms to assign {} work units to {} fragments", new Object[]{watch.elapsed(TimeUnit.MILLISECONDS), this.units.size(), this.incomingEndpoints.size()});
        return this.mappings;
    }

    private LinkedList<WorkEndpointListPair<T>> assign(List<WorkEndpointListPair<T>> workList, Map<CoordinationProtos.DrillbitEndpoint, FragIteratorWrapper> endpointIterators, boolean assignMaxLeftOvers) {
        LinkedList<WorkEndpointListPair<T>> currentUnassignedList = Lists.newLinkedList();
        block0: for (WorkEndpointListPair<T> workPair : workList) {
            List<CoordinationProtos.DrillbitEndpoint> endpoints = workPair.sortedEndpoints;
            for (CoordinationProtos.DrillbitEndpoint endpoint : endpoints) {
                FragIteratorWrapper iteratorWrapper = endpointIterators.get(endpoint);
                if (iteratorWrapper == null || iteratorWrapper.count >= (assignMaxLeftOvers ? iteratorWrapper.maxCount + iteratorWrapper.maxCountLeftOver : iteratorWrapper.maxCount)) continue;
                Integer assignment = iteratorWrapper.iter.next();
                ++iteratorWrapper.count;
                this.mappings.put((Object)assignment, (CompleteWork)workPair.work);
                continue block0;
            }
            currentUnassignedList.add(workPair);
        }
        return currentUnassignedList;
    }

    private void assignLeftovers(LinkedList<WorkEndpointListPair<T>> unassignedWorkList, Map<CoordinationProtos.DrillbitEndpoint, FragIteratorWrapper> endpointIterators, boolean assignMinimum) {
        block0: for (FragIteratorWrapper iteratorWrapper : endpointIterators.values()) {
            while (++iteratorWrapper.count < (assignMinimum ? iteratorWrapper.minCount : iteratorWrapper.maxCount + iteratorWrapper.maxCountLeftOver)) {
                WorkEndpointListPair<T> workPair = unassignedWorkList.poll();
                if (workPair == null) break block0;
                Integer assignment = iteratorWrapper.iter.next();
                this.mappings.put((Object)assignment, (CompleteWork)workPair.work);
            }
        }
    }

    private LinkedList<WorkEndpointListPair<T>> getWorkList() {
        LinkedList<WorkEndpointListPair<T>> workList = Lists.newLinkedList();
        for (CompleteWork work : this.units) {
            ArrayList<2> entries = Lists.newArrayList();
            for (ObjectLongCursor cursor : work.getByteMap()) {
                final CoordinationProtos.DrillbitEndpoint drillbitEndpoint = (CoordinationProtos.DrillbitEndpoint)cursor.key;
                final Long val = cursor.value;
                Map.Entry<CoordinationProtos.DrillbitEndpoint, Long> entry = new Map.Entry<CoordinationProtos.DrillbitEndpoint, Long>(){

                    @Override
                    public CoordinationProtos.DrillbitEndpoint getKey() {
                        return drillbitEndpoint;
                    }

                    @Override
                    public Long getValue() {
                        return val;
                    }

                    @Override
                    public Long setValue(Long value) {
                        throw new UnsupportedOperationException();
                    }
                };
                entries.add(entry);
            }
            Collections.sort(entries, comparator);
            ArrayList<CoordinationProtos.DrillbitEndpoint> sortedEndpoints = Lists.newArrayList();
            for (Map.Entry entry : entries) {
                sortedEndpoints.add((CoordinationProtos.DrillbitEndpoint)entry.getKey());
            }
            workList.add(new WorkEndpointListPair<CompleteWork>(work, sortedEndpoints));
        }
        return workList;
    }

    /*
     * WARNING - void declaration
     */
    private Map<CoordinationProtos.DrillbitEndpoint, FragIteratorWrapper> getEndpointIterators() {
        LinkedHashMap<CoordinationProtos.DrillbitEndpoint, FragIteratorWrapper> map = Maps.newLinkedHashMap();
        LinkedHashMap<CoordinationProtos.DrillbitEndpoint, void> mmap = Maps.newLinkedHashMap();
        for (int i = 0; i < this.incomingEndpoints.size(); ++i) {
            void var5_5;
            CoordinationProtos.DrillbitEndpoint endpoint = this.incomingEndpoints.get(i);
            List list = (List)mmap.get(this.incomingEndpoints.get(i));
            if (list == null) {
                ArrayList arrayList = Lists.newArrayList();
            }
            var5_5.add(i);
            mmap.put(endpoint, var5_5);
        }
        int totalMaxCount = 0;
        for (CoordinationProtos.DrillbitEndpoint drillbitEndpoint : mmap.keySet()) {
            FragIteratorWrapper wrapper = new FragIteratorWrapper();
            wrapper.iter = Iterators.cycle((Iterable)mmap.get(drillbitEndpoint));
            int maxCount = (int)((double)((List)mmap.get(drillbitEndpoint)).size() / (double)this.incomingEndpoints.size() * (double)this.units.size());
            wrapper.maxCount = Math.min(this.maxWork * ((List)mmap.get(drillbitEndpoint)).size(), maxCount);
            totalMaxCount += wrapper.maxCount;
            wrapper.minCount = Math.max(this.maxWork - 1, 1) * ((List)mmap.get(drillbitEndpoint)).size();
            map.put(drillbitEndpoint, wrapper);
        }
        block2: while (totalMaxCount < this.units.size()) {
            for (Map.Entry entry : map.entrySet()) {
                FragIteratorWrapper iteratorWrapper = (FragIteratorWrapper)entry.getValue();
                ++iteratorWrapper.maxCountLeftOver;
                if (++totalMaxCount != this.units.size()) continue;
                continue block2;
            }
        }
        return map;
    }

    private static class WorkEndpointListPair<T> {
        T work;
        List<CoordinationProtos.DrillbitEndpoint> sortedEndpoints;

        WorkEndpointListPair(T work, List<CoordinationProtos.DrillbitEndpoint> sortedEndpoints) {
            this.work = work;
            this.sortedEndpoints = sortedEndpoints;
        }
    }

    private static class FragIteratorWrapper {
        int count = 0;
        int maxCount;
        int maxCountLeftOver;
        int minCount;
        Iterator<Integer> iter;

        private FragIteratorWrapper() {
        }
    }
}

