/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.schedule;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.cursors.ObjectFloatCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityCreator {
    private static final Logger logger = LoggerFactory.getLogger(AffinityCreator.class);

    public static <T extends CompleteWork> List<EndpointAffinity> getAffinityMap(List<T> work) {
        Stopwatch watch = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        long totalBytes = work.stream().mapToLong(CompleteWork::getTotalBytes).sum();
        ObjectFloatHashMap affinities = new ObjectFloatHashMap();
        for (CompleteWork entry : work) {
            for (ObjectLongCursor cursor : entry.getByteMap()) {
                long bytes = cursor.value;
                float affinity = totalBytes == 0L ? 0.0f : (float)bytes / (float)totalBytes;
                affinities.putOrAdd((Object)((CoordinationProtos.DrillbitEndpoint)cursor.key), affinity, affinity);
            }
        }
        LinkedList<EndpointAffinity> affinityList = new LinkedList<EndpointAffinity>();
        for (ObjectFloatCursor d : affinities) {
            logger.debug("Endpoint {} has affinity {}", (Object)((CoordinationProtos.DrillbitEndpoint)d.key).getAddress(), (Object)Float.valueOf(d.value));
            affinityList.add(new EndpointAffinity((CoordinationProtos.DrillbitEndpoint)d.key, d.value));
        }
        if (watch != null) {
            logger.debug("Took {} ms to get operator affinity", (Object)watch.elapsed(TimeUnit.MILLISECONDS));
        }
        return affinityList;
    }
}

