/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pojo;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.store.pojo.AbstractPojoWriter;
import org.apache.drill.exec.store.pojo.PojoWriter;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.VarDecimalVector;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;

public class PojoWriters {
    public static PojoWriter getWriter(Class<?> type, String fieldName, DrillBuf buffer) throws ExecutionSetupException {
        if (type == Integer.class) {
            return new NIntWriter(fieldName);
        }
        if (type == Long.class) {
            return new NBigIntWriter(fieldName);
        }
        if (type == Boolean.class) {
            return new NBooleanWriter(fieldName);
        }
        if (type == Float.class) {
            return new NFloatWriter(fieldName);
        }
        if (type == Double.class) {
            return new NDoubleWriter(fieldName);
        }
        if (type.isEnum()) {
            return new EnumWriter(fieldName, buffer);
        }
        if (type == String.class) {
            return new StringWriter(fieldName, buffer);
        }
        if (type == BigDecimal.class) {
            return new DecimalWriter(fieldName);
        }
        if (type == Timestamp.class) {
            return new NTimeStampWriter(fieldName);
        }
        if (type == Integer.TYPE) {
            return new IntWriter(fieldName);
        }
        if (type == Float.TYPE) {
            return new FloatWriter(fieldName);
        }
        if (type == Double.TYPE) {
            return new DoubleWriter(fieldName);
        }
        if (type == Boolean.TYPE) {
            return new BitWriter(fieldName);
        }
        if (type == Long.TYPE) {
            return new LongWriter(fieldName);
        }
        throw new ExecutionSetupException(String.format("PojoRecordReader doesn't yet support conversions from the type [%s].", type));
    }

    public static class NIntWriter
    extends AbstractPojoWriter<NullableIntVector> {
        public NIntWriter(String fieldName) {
            super(fieldName, Types.optional(TypeProtos.MinorType.INT));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                ((NullableIntVector)this.vector).getMutator().setSafe(outboundIndex, (Integer)value);
            }
        }
    }

    public static class NBigIntWriter
    extends AbstractPojoWriter<NullableBigIntVector> {
        public NBigIntWriter(String fieldName) {
            super(fieldName, Types.optional(TypeProtos.MinorType.BIGINT));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                ((NullableBigIntVector)this.vector).getMutator().setSafe(outboundIndex, (Long)value);
            }
        }
    }

    public static class NBooleanWriter
    extends AbstractPojoWriter<NullableBitVector> {
        public NBooleanWriter(String fieldName) {
            super(fieldName, Types.optional(TypeProtos.MinorType.BIT));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                ((NullableBitVector)this.vector).getMutator().setSafe(outboundIndex, (Boolean)value != false ? 1 : 0);
            }
        }
    }

    public static class NFloatWriter
    extends AbstractPojoWriter<NullableFloat4Vector> {
        public NFloatWriter(String fieldName) {
            super(fieldName, Types.optional(TypeProtos.MinorType.FLOAT4));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                ((NullableFloat4Vector)this.vector).getMutator().setSafe(outboundIndex, ((Float)value).floatValue());
            }
        }
    }

    public static class NDoubleWriter
    extends AbstractPojoWriter<NullableFloat8Vector> {
        public NDoubleWriter(String fieldName) {
            super(fieldName, Types.optional(TypeProtos.MinorType.FLOAT8));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                ((NullableFloat8Vector)this.vector).getMutator().setSafe(outboundIndex, (Double)value);
            }
        }
    }

    public static class EnumWriter
    extends AbstractStringWriter {
        public EnumWriter(String fieldName, DrillBuf managedBuf) {
            super(fieldName, managedBuf);
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value == null) {
                return;
            }
            this.writeString(((Enum)value).name(), outboundIndex);
        }
    }

    public static class StringWriter
    extends AbstractStringWriter {
        public StringWriter(String fieldName, DrillBuf managedBuf) {
            super(fieldName, managedBuf);
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                this.writeString((String)value, outboundIndex);
            }
        }
    }

    public static class DecimalWriter
    extends AbstractPojoWriter<VarDecimalVector> {
        public DecimalWriter(String fieldName) {
            super(fieldName, Types.optional(TypeProtos.MinorType.VARDECIMAL));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                ((VarDecimalVector)this.vector).getMutator().setSafe(outboundIndex, (BigDecimal)value);
            }
        }
    }

    public static class NTimeStampWriter
    extends AbstractPojoWriter<NullableTimeStampVector> {
        public NTimeStampWriter(String fieldName) {
            super(fieldName, Types.optional(TypeProtos.MinorType.TIMESTAMP));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            if (value != null) {
                ((NullableTimeStampVector)this.vector).getMutator().setSafe(outboundIndex, ((Timestamp)value).getTime());
            }
        }
    }

    public static class IntWriter
    extends AbstractPojoWriter<IntVector> {
        public IntWriter(String fieldName) {
            super(fieldName, Types.required(TypeProtos.MinorType.INT));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            ((IntVector)this.vector).getMutator().setSafe(outboundIndex, (Integer)value);
        }
    }

    public static class FloatWriter
    extends AbstractPojoWriter<Float4Vector> {
        public FloatWriter(String fieldName) {
            super(fieldName, Types.required(TypeProtos.MinorType.FLOAT4));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            ((Float4Vector)this.vector).getMutator().setSafe(outboundIndex, ((Float)value).floatValue());
        }
    }

    public static class DoubleWriter
    extends AbstractPojoWriter<Float8Vector> {
        public DoubleWriter(String fieldName) {
            super(fieldName, Types.required(TypeProtos.MinorType.FLOAT8));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            ((Float8Vector)this.vector).getMutator().setSafe(outboundIndex, (Double)value);
        }
    }

    public static class BitWriter
    extends AbstractPojoWriter<BitVector> {
        public BitWriter(String fieldName) {
            super(fieldName, Types.required(TypeProtos.MinorType.BIT));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            ((BitVector)this.vector).getMutator().setSafe(outboundIndex, (Boolean)value != false ? 1 : 0);
        }
    }

    public static class LongWriter
    extends AbstractPojoWriter<BigIntVector> {
        public LongWriter(String fieldName) {
            super(fieldName, Types.required(TypeProtos.MinorType.BIGINT));
        }

        @Override
        public void writeField(Object value, int outboundIndex) {
            ((BigIntVector)this.vector).getMutator().setSafe(outboundIndex, (Long)value);
        }
    }

    private static abstract class AbstractStringWriter
    extends AbstractPojoWriter<NullableVarCharVector> {
        private DrillBuf data;
        private final NullableVarCharHolder holder = new NullableVarCharHolder();

        public AbstractStringWriter(String fieldName, DrillBuf managedBuf) {
            super(fieldName, Types.optional(TypeProtos.MinorType.VARCHAR));
            this.data = managedBuf;
            this.ensureLength(100);
        }

        void ensureLength(int len) {
            this.data = this.data.reallocIfNeeded(len);
        }

        public void writeString(String s, int outboundIndex) {
            this.holder.isSet = 1;
            byte[] bytes = s.getBytes(Charsets.UTF_8);
            this.ensureLength(bytes.length);
            this.data.clear();
            this.data.writeBytes(bytes);
            this.holder.buffer = this.data;
            this.holder.start = 0;
            this.holder.end = bytes.length;
            ((NullableVarCharVector)this.vector).getMutator().setSafe(outboundIndex, this.holder);
        }
    }
}

