/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pojo;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.pojo.AbstractPojoRecordReader;
import org.apache.drill.exec.store.pojo.PojoWriter;

@JsonTypeName(value="PojoRecordReader")
public class PojoRecordReader<T>
extends AbstractPojoRecordReader<T> {
    private final Class<T> pojoClass;
    private final List<Field> fields;

    public PojoRecordReader(Class<T> pojoClass, List<T> records) {
        super(records);
        this.pojoClass = pojoClass;
        this.fields = new ArrayList<Field>();
    }

    public PojoRecordReader(Class<T> pojoClass, List<T> records, int maxRecordToRead) {
        super(records, maxRecordToRead);
        this.pojoClass = pojoClass;
        this.fields = new ArrayList<Field>();
    }

    @Override
    protected List<PojoWriter> setupWriters(OutputMutator output) throws ExecutionSetupException {
        Field[] declaredFields;
        ArrayList<PojoWriter> writers = new ArrayList<PojoWriter>();
        for (Field field : declaredFields = this.pojoClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            writers.add(this.initWriter(field.getType(), field.getName(), output));
            this.fields.add(field);
        }
        return writers;
    }

    @Override
    protected Object getFieldValue(T row, int fieldPosition) {
        try {
            return this.fields.get(fieldPosition).get(row);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DrillRuntimeException("Failure while trying to use PojoRecordReader.", e);
        }
    }

    @Override
    public String toString() {
        return "PojoRecordReader{pojoClass = " + this.pojoClass + ", recordCount = " + this.records.size() + "}";
    }
}

