/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pojo;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.pojo.PojoWriter;
import org.apache.drill.exec.vector.ValueVector;

public abstract class AbstractPojoWriter<V extends ValueVector>
implements PojoWriter {
    protected V vector;
    private final String fieldName;
    private final TypeProtos.MajorType type;

    public AbstractPojoWriter(String fieldName, TypeProtos.MajorType type) {
        this.fieldName = fieldName;
        this.type = type;
    }

    @Override
    public void init(OutputMutator output) throws SchemaChangeException {
        MaterializedField mf = MaterializedField.create(this.fieldName, this.type);
        Class<? extends ValueVector> valueVectorClass = TypeHelper.getValueVectorClass(this.type.getMinorType(), this.type.getMode());
        this.vector = output.addField(mf, valueVectorClass);
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void setValueCount(int valueCount) {
        this.vector.getMutator().setValueCount(valueCount);
    }

    @Override
    public void cleanup() {
    }
}

