/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pojo;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.pojo.PojoWriter;
import org.apache.drill.exec.store.pojo.PojoWriters;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPojoRecordReader<T>
extends AbstractRecordReader
implements Iterable<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPojoRecordReader.class);
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(AbstractPojoRecordReader.class);
    public static final int DEFAULT_RECORDS_PER_BATCH = 4000;
    @JsonProperty
    private final int recordsPerBatch;
    @JsonProperty
    protected final List<T> records;
    protected List<PojoWriter> writers;
    private Iterator<T> currentIterator;
    private OperatorContext operatorContext;

    protected AbstractPojoRecordReader(List<T> records) {
        this(records, 4000);
    }

    protected AbstractPojoRecordReader(List<T> records, int recordsPerBatch) {
        this.records = records;
        this.recordsPerBatch = Math.min(recordsPerBatch, 4000);
    }

    @Override
    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        this.operatorContext = context;
        this.writers = this.setupWriters(output);
        this.currentIterator = this.records.iterator();
    }

    @Override
    public int next() {
        int recordCount;
        boolean allocated = false;
        injector.injectPause(this.operatorContext.getExecutionControls(), "read-next", logger);
        for (recordCount = 0; this.currentIterator.hasNext() && recordCount < this.recordsPerBatch; ++recordCount) {
            if (!allocated) {
                this.allocate();
                allocated = true;
            }
            T row = this.currentIterator.next();
            for (int i = 0; i < this.writers.size(); ++i) {
                PojoWriter writer = this.writers.get(i);
                writer.writeField(this.getFieldValue(row, i), recordCount);
            }
        }
        if (recordCount != 0) {
            this.setValueCount(recordCount);
        }
        return recordCount;
    }

    @Override
    public void allocate(Map<String, ValueVector> vectorMap) throws OutOfMemoryException {
        for (ValueVector v : vectorMap.values()) {
            AllocationHelper.allocate(v, this.recordsPerBatch, 50, 10);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Iterator<T> iterator() {
        return this.records.iterator();
    }

    protected PojoWriter initWriter(Class<?> type, String fieldName, OutputMutator output) throws ExecutionSetupException {
        PojoWriter writer = PojoWriters.getWriter(type, fieldName, output.getManagedBuffer());
        try {
            writer.init(output);
            return writer;
        }
        catch (SchemaChangeException e) {
            throw new ExecutionSetupException("Failure while setting up schema for AbstractPojoRecordReader.", e);
        }
    }

    private void allocate() {
        for (PojoWriter writer : this.writers) {
            writer.allocate();
        }
    }

    private void setValueCount(int recordCount) {
        for (PojoWriter writer : this.writers) {
            writer.setValueCount(recordCount);
        }
    }

    protected abstract List<PojoWriter> setupWriters(OutputMutator var1) throws ExecutionSetupException;

    protected abstract Object getFieldValue(T var1, int var2);
}

