/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.plan.rule;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.index.ExprToRex;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.store.plan.PluginImplementor;
import org.apache.drill.exec.store.plan.rel.PluginProjectRel;
import org.apache.drill.exec.store.plan.rule.PluginConverterRule;
import org.apache.drill.exec.util.Utilities;

public class PluginProjectRule
extends PluginConverterRule {
    public PluginProjectRule(RelTrait in, Convention out, PluginImplementor pluginImplementor) {
        super(Project.class, in, out, "PluginProjectRule", pluginImplementor);
    }

    public RelNode convert(RelNode rel) {
        Project project = (Project)rel;
        if (!this.getPluginImplementor().splitProject(project)) {
            return new PluginProjectRel(this.getOutConvention(), project.getCluster(), project.getTraitSet().replace((RelTrait)this.getOutConvention()), PluginProjectRule.convert((RelNode)project.getInput(), (RelTraitSet)project.getTraitSet().replace((RelTrait)this.getOutConvention())), project.getProjects(), project.getRowType());
        }
        RelDataType inputRowType = project.getInput().getRowType();
        if (inputRowType.getFieldList().isEmpty()) {
            return null;
        }
        DrillRelOptUtil.ProjectPushInfo projectPushInfo = DrillRelOptUtil.getFieldsInformation(inputRowType, project.getProjects());
        Project pluginProject = this.createPluginProject(project, projectPushInfo);
        if (Utilities.isStarQuery(projectPushInfo.getFields()) || pluginProject.getRowType().equals(inputRowType)) {
            return null;
        }
        List<RexNode> newProjects = project.getProjects().stream().map(n -> (RexNode)n.accept((RexVisitor)projectPushInfo.getInputReWriter())).collect(Collectors.toList());
        Project newProject = this.createProject(project, pluginProject, newProjects);
        if (ProjectRemoveRule.isTrivial((Project)newProject)) {
            return pluginProject;
        }
        return newProject;
    }

    protected Project createPluginProject(Project project, DrillRelOptUtil.ProjectPushInfo projectPushInfo) {
        ExprToRex exprToRex = new ExprToRex(project.getInput(), project.getInput().getRowType(), project.getCluster().getRexBuilder());
        List newProjects = projectPushInfo.getFields().stream().map(f -> f.accept(exprToRex, null)).collect(Collectors.toList());
        return new PluginProjectRel(this.getOutConvention(), project.getCluster(), project.getTraitSet().replace((RelTrait)this.getOutConvention()), PluginProjectRule.convert((RelNode)project.getInput(), (RelTraitSet)project.getTraitSet().replace((RelTrait)this.getOutConvention())), newProjects, projectPushInfo.createNewRowType(project.getCluster().getTypeFactory()));
    }

    protected Project createProject(Project project, Project input, List<RexNode> newProjects) {
        return new DrillProjectRel(project.getCluster(), project.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), (RelNode)input, newProjects, project.getRowType());
    }
}

