/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.plan.rule;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.store.plan.PluginImplementor;

public abstract class PluginConverterRule
extends ConverterRule {
    private final PluginImplementor pluginImplementor;

    protected PluginConverterRule(Class<? extends RelNode> clazz, RelTrait in, Convention out, String description, PluginImplementor pluginImplementor) {
        super((ConverterRule.Config)ConverterRule.Config.INSTANCE.withConversion(clazz, input -> true, in, (RelTrait)out, description).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER).as(ConverterRule.Config.class));
        this.pluginImplementor = pluginImplementor;
    }

    public PluginImplementor getPluginImplementor() {
        return this.pluginImplementor;
    }

    public boolean matches(RelOptRuleCall call) {
        RelNode rel = call.rel(0);
        boolean canImplement = false;
        if (rel instanceof Aggregate) {
            canImplement = this.pluginImplementor.canImplement((Aggregate)rel);
        } else if (rel instanceof Filter) {
            canImplement = this.pluginImplementor.canImplement((Filter)rel);
        } else if (rel instanceof DrillLimitRelBase) {
            canImplement = this.pluginImplementor.canImplement((DrillLimitRelBase)rel);
        } else if (rel instanceof Project) {
            canImplement = this.pluginImplementor.canImplement((Project)rel);
        } else if (rel instanceof Sort) {
            canImplement = this.pluginImplementor.canImplement((Sort)rel);
        } else if (rel instanceof Union) {
            canImplement = this.pluginImplementor.canImplement((Union)rel);
        } else if (rel instanceof Join) {
            canImplement = this.pluginImplementor.canImplement((Join)rel);
        }
        return canImplement && super.matches(call);
    }
}

