/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.plan.rel;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.store.plan.PluginImplementor;
import org.apache.drill.exec.store.plan.rel.PluginRel;
import org.apache.drill.exec.util.Utilities;

public class StoragePluginTableScan
extends DrillScanRelBase
implements PluginRel {
    private final RelDataType rowType;

    public StoragePluginTableScan(RelOptCluster cluster, RelTraitSet traits, GroupScan grpScan, RelOptTable table, RelDataType rowType) {
        super(cluster, traits, grpScan.clone(StoragePluginTableScan.getColumns(rowType)), table);
        this.rowType = rowType;
    }

    @Override
    public void implement(PluginImplementor implementor) throws IOException {
        implementor.implement(this);
    }

    @Override
    public DrillScanRelBase copy(RelTraitSet traitSet, GroupScan scan, RelDataType rowType) {
        return new StoragePluginTableScan(this.getCluster(), traitSet, scan, this.getTable(), rowType);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return this.getGroupScan().getScanStats(mq).getRecordCount();
    }

    public RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("groupScan", (Object)this.getGroupScan().getDigest());
    }

    @Override
    public boolean canImplement(PluginImplementor implementor) {
        return implementor.canImplement(this);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        List<SchemaPath> columns = this.groupScan.getColumns();
        double columnCount = Utilities.isStarQuery(columns) ? 10000.0 : Math.pow(this.getRowType().getFieldCount(), 2.0) / (double)Math.max(columns.size(), 1);
        double rowCount = this.estimateRowCount(mq);
        double valueCount = rowCount * columnCount;
        return planner.getCostFactory().makeCost(rowCount, valueCount, 0.0).multiplyBy(0.1);
    }

    private static List<SchemaPath> getColumns(RelDataType rowType) {
        return rowType.getFieldList().stream().map(filed -> filed.isDynamicStar() ? SchemaPath.STAR_COLUMN : SchemaPath.getSimplePath(filed.getName())).collect(Collectors.toList());
    }
}

