/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet2;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetColumnMetadata;
import org.apache.drill.exec.store.parquet2.DrillParquetMapGroupConverter;
import org.apache.drill.exec.vector.complex.impl.AbstractRepeatedMapWriter;
import org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;
import org.apache.drill.exec.vector.complex.writer.Float8Writer;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import org.apache.drill.exec.vector.complex.writer.TimeWriter;
import org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;
import org.apache.drill.shaded.guava.com.google.common.primitives.Ints;
import org.apache.drill.shaded.guava.com.google.common.primitives.Longs;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class DrillParquetGroupConverter
extends GroupConverter {
    protected final List<Converter> converters;
    private final BaseWriter baseWriter;
    private final OutputMutator mutator;
    private final OptionManager options;
    private final ParquetReaderUtility.DateCorruptionStatus containsCorruptedDates;
    private String converterName;

    protected DrillParquetGroupConverter(OutputMutator mutator, BaseWriter baseWriter, OptionManager options, ParquetReaderUtility.DateCorruptionStatus containsCorruptedDates) {
        this.mutator = mutator;
        this.baseWriter = baseWriter;
        this.options = options;
        this.containsCorruptedDates = containsCorruptedDates;
        this.converters = new ArrayList<Converter>();
    }

    public DrillParquetGroupConverter(OutputMutator mutator, BaseWriter baseWriter, GroupType schema, Collection<SchemaPath> columns, OptionManager options, ParquetReaderUtility.DateCorruptionStatus containsCorruptedDates, boolean skipRepeated, String parentName) {
        this(mutator, baseWriter, options, containsCorruptedDates);
        this.converterName = String.format("%s>%s[%s-%d]", parentName, schema.getName(), baseWriter.getClass().getSimpleName(), baseWriter.hashCode());
        Iterator<SchemaPath> colIterator = columns.iterator();
        for (Type type : schema.getFields()) {
            String name = type.getName();
            PathSegment colNextChild = null;
            while (colIterator.hasNext()) {
                String colPathName;
                PathSegment.NameSegment colPath = colIterator.next().getRootSegment();
                if (!((PathSegment)colPath).isNamed() || "**".equals(colPathName = ((PathSegment)colPath).getNameSegment().getPath()) || !colPathName.equalsIgnoreCase(name)) continue;
                name = colPathName;
                colNextChild = colPath.getChild();
                break;
            }
            Converter converter = this.createFieldConverter(skipRepeated, type, name, colNextChild);
            this.converters.add(converter);
        }
    }

    private Converter createFieldConverter(boolean skipRepeated, Type fieldType, String name, PathSegment colNextChild) {
        Object converter;
        if (fieldType.isPrimitive()) {
            converter = this.getConverterForType(name, fieldType.asPrimitiveType());
        } else {
            while (colNextChild != null && !colNextChild.isNamed()) {
                colNextChild = colNextChild.getChild();
            }
            List<SchemaPath> columns = colNextChild == null ? Collections.emptyList() : Collections.singletonList(new SchemaPath(colNextChild.getNameSegment()));
            GroupType fieldGroupType = fieldType.asGroupType();
            if (ParquetReaderUtility.isLogicalListType(fieldGroupType)) {
                BaseWriter writer = this.getWriter(name, BaseWriter.MapWriter::list, BaseWriter.ListWriter::list);
                converter = new DrillParquetGroupConverter(this.mutator, writer, fieldGroupType, columns, this.options, this.containsCorruptedDates, true, this.converterName);
            } else if (this.options.getOption(ExecConstants.PARQUET_READER_ENABLE_MAP_SUPPORT_VALIDATOR) && ParquetReaderUtility.isLogicalMapType(fieldGroupType)) {
                BaseWriter writer = this.getWriter(name, BaseWriter.MapWriter::dict, BaseWriter.ListWriter::dict);
                converter = new DrillParquetMapGroupConverter(this.mutator, (BaseWriter.DictWriter)writer, fieldGroupType, this.options, this.containsCorruptedDates);
            } else if (fieldType.isRepetition(Type.Repetition.REPEATED)) {
                if (skipRepeated) {
                    converter = new DrillIntermediateParquetGroupConverter(this.mutator, this.baseWriter, fieldGroupType, columns, this.options, this.containsCorruptedDates, false, this.converterName);
                } else {
                    BaseWriter writer = this.getWriter(name, (m, s) -> m.list((String)s).map(), l -> l.list().map());
                    converter = new DrillParquetGroupConverter(this.mutator, writer, fieldGroupType, columns, this.options, this.containsCorruptedDates, false, this.converterName);
                }
            } else {
                BaseWriter writer = this.getWriter(name, BaseWriter.MapWriter::map, BaseWriter.ListWriter::map);
                converter = new DrillParquetGroupConverter(this.mutator, writer, fieldGroupType, columns, this.options, this.containsCorruptedDates, false, this.converterName);
            }
        }
        return converter;
    }

    protected PrimitiveConverter getConverterForType(final String name, final PrimitiveType type) {
        switch (type.getPrimitiveTypeName()) {
            case INT32: {
                if (type.getOriginalType() == null) {
                    return this.getIntConverter(name, type);
                }
                switch (type.getOriginalType()) {
                    case UINT_8: 
                    case UINT_16: 
                    case UINT_32: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        return this.getIntConverter(name, type);
                    }
                    case DECIMAL: {
                        ParquetReaderUtility.checkDecimalTypeEnabled(this.options);
                        return this.getVarDecimalConverter(name, type);
                    }
                    case DATE: {
                        DateWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).date(), l -> l.list().date()) : this.getWriter(name, (m, f) -> m.date((String)f), l -> l.date());
                        switch (this.containsCorruptedDates) {
                            case META_SHOWS_CORRUPTION: {
                                return new DrillCorruptedDateConverter(writer);
                            }
                            case META_SHOWS_NO_CORRUPTION: {
                                return new DrillDateConverter(writer);
                            }
                            case META_UNCLEAR_TEST_VALUES: {
                                return new CorruptionDetectingDateConverter(writer);
                            }
                        }
                        throw new DrillRuntimeException(String.format("Issue setting up parquet reader for date type, unrecognized date corruption status %s. See DRILL-4203 for more info.", new Object[]{this.containsCorruptedDates}));
                    }
                    case TIME_MILLIS: {
                        TimeWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).time(), l -> l.list().time()) : this.getWriter(name, (m, f) -> m.time((String)f), l -> l.time());
                        return new DrillTimeConverter(writer);
                    }
                }
                throw new UnsupportedOperationException("Unsupported type: " + type.getOriginalType());
            }
            case INT64: {
                if (type.getOriginalType() == null) {
                    return this.getBigIntConverter(name, type);
                }
                switch (type.getOriginalType()) {
                    case UINT_64: 
                    case INT_64: {
                        return this.getBigIntConverter(name, type);
                    }
                    case TIMESTAMP_MICROS: {
                        TimeStampWriter writer = this.getTimeStampWriter(name, type);
                        return new DrillTimeStampMicrosConverter(writer);
                    }
                    case TIME_MICROS: {
                        TimeWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).time(), l -> l.list().time()) : this.getWriter(name, BaseWriter.MapWriter::time, BaseWriter.ListWriter::time);
                        return new DrillTimeMicrosConverter(writer);
                    }
                    case DECIMAL: {
                        ParquetReaderUtility.checkDecimalTypeEnabled(this.options);
                        return this.getVarDecimalConverter(name, type);
                    }
                    case TIMESTAMP_MILLIS: {
                        TimeStampWriter writer = this.getTimeStampWriter(name, type);
                        return new DrillTimeStampConverter(writer);
                    }
                }
                throw new UnsupportedOperationException("Unsupported type " + type.getOriginalType());
            }
            case INT96: {
                if (type.getOriginalType() == null) {
                    if (this.options.getOption((String)"store.parquet.reader.int96_as_timestamp").bool_val.booleanValue()) {
                        TimeStampWriter writer = this.getTimeStampWriter(name, type);
                        return new DrillFixedBinaryToTimeStampConverter(writer);
                    }
                    VarBinaryWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).varBinary(), l -> l.list().varBinary()) : this.getWriter(name, (m, f) -> m.varBinary((String)f), listWriter -> listWriter.varBinary());
                    return new DrillFixedBinaryToVarbinaryConverter(writer, ParquetColumnMetadata.getTypeLengthInBits(type.getPrimitiveTypeName()) / 8, this.mutator.getManagedBuffer());
                }
            }
            case FLOAT: {
                Float4Writer writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).float4(), l -> l.list().float4()) : this.getWriter(name, (m, f) -> m.float4((String)f), l -> l.float4());
                return new DrillFloat4Converter(writer);
            }
            case DOUBLE: {
                Float8Writer writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).float8(), l -> l.list().float8()) : this.getWriter(name, (m, f) -> m.float8((String)f), l -> l.float8());
                return new DrillFloat8Converter(writer);
            }
            case BOOLEAN: {
                BitWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).bit(), l -> l.list().bit()) : this.getWriter(name, (m, f) -> m.bit((String)f), l -> l.bit());
                return new DrillBoolConverter(writer);
            }
            case BINARY: {
                LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveConverter> typeAnnotationVisitor = new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveConverter>(){

                    public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        ParquetReaderUtility.checkDecimalTypeEnabled(DrillParquetGroupConverter.this.options);
                        return Optional.of(DrillParquetGroupConverter.this.getVarDecimalConverter(name, type));
                    }

                    public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                        return Optional.of(DrillParquetGroupConverter.this.getVarCharConverter(name, type));
                    }

                    public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation stringLogicalType) {
                        return Optional.of(DrillParquetGroupConverter.this.getVarCharConverter(name, type));
                    }
                };
                Supplier<PrimitiveConverter> converterSupplier = () -> {
                    VarBinaryWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).varBinary(), l -> l.list().varBinary()) : this.getWriter(name, BaseWriter.MapWriter::varBinary, BaseWriter.ListWriter::varBinary);
                    return new DrillVarBinaryConverter(writer, this.mutator.getManagedBuffer());
                };
                return Optional.ofNullable(type.getLogicalTypeAnnotation()).map(arg_0 -> DrillParquetGroupConverter.lambda$getConverterForType$31((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)typeAnnotationVisitor, arg_0)).flatMap(Function.identity()).orElseGet(converterSupplier);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveConverter> typeAnnotationVisitor = new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveConverter>(){

                    public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        ParquetReaderUtility.checkDecimalTypeEnabled(DrillParquetGroupConverter.this.options);
                        return Optional.of(DrillParquetGroupConverter.this.getVarDecimalConverter(name, type));
                    }

                    public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
                        IntervalWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? (IntervalWriter)DrillParquetGroupConverter.this.getWriter(name, (m, f) -> m.list((String)f).interval(), l -> l.list().interval()) : (IntervalWriter)DrillParquetGroupConverter.this.getWriter(name, BaseWriter.MapWriter::interval, BaseWriter.ListWriter::interval);
                        return Optional.of(new DrillFixedLengthByteArrayToInterval(writer));
                    }
                };
                Supplier<PrimitiveConverter> converterSupplier = () -> {
                    VarBinaryWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).varBinary(), l -> l.list().varBinary()) : this.getWriter(name, BaseWriter.MapWriter::varBinary, BaseWriter.ListWriter::varBinary);
                    return new DrillFixedBinaryToVarbinaryConverter(writer, type.getTypeLength(), this.mutator.getManagedBuffer());
                };
                return Optional.ofNullable(type.getLogicalTypeAnnotation()).map(arg_0 -> DrillParquetGroupConverter.lambda$getConverterForType$35((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)typeAnnotationVisitor, arg_0)).flatMap(Function.identity()).orElseGet(converterSupplier);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getPrimitiveTypeName());
    }

    private PrimitiveConverter getVarCharConverter(String name, PrimitiveType type) {
        VarCharWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).varChar(), l -> l.list().varChar()) : this.getWriter(name, (m, f) -> m.varChar((String)f), l -> l.varChar());
        return new DrillVarCharConverter(writer, this.mutator.getManagedBuffer());
    }

    private TimeStampWriter getTimeStampWriter(String name, PrimitiveType type) {
        return type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).timeStamp(), l -> l.list().timeStamp()) : this.getWriter(name, (m, f) -> m.timeStamp((String)f), l -> l.timeStamp());
    }

    private PrimitiveConverter getBigIntConverter(String name, PrimitiveType type) {
        BigIntWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).bigInt(), l -> l.list().bigInt()) : this.getWriter(name, (m, f) -> m.bigInt((String)f), l -> l.bigInt());
        return new DrillBigIntConverter(writer);
    }

    private PrimitiveConverter getIntConverter(String name, PrimitiveType type) {
        IntWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).integer(), l -> l.list().integer()) : this.getWriter(name, (m, f) -> m.integer((String)f), l -> l.integer());
        return new DrillIntConverter(writer);
    }

    private PrimitiveConverter getVarDecimalConverter(String name, PrimitiveType type) {
        int scale = type.getDecimalMetadata().getScale();
        int precision = type.getDecimalMetadata().getPrecision();
        VarDecimalWriter writer = type.isRepetition(Type.Repetition.REPEATED) ? this.getWriter(name, (m, f) -> m.list((String)f).varDecimal(precision, scale), l -> l.list().varDecimal(precision, scale)) : this.getWriter(name, (m, f) -> m.varDecimal((String)f, precision, scale), l -> l.varDecimal(precision, scale));
        return new DrillVarDecimalConverter(writer, precision, scale, this.mutator.getManagedBuffer());
    }

    public Converter getConverter(int i) {
        return this.converters.get(i);
    }

    public void start() {
        if (this.isMapWriter()) {
            ((BaseWriter.MapWriter)this.baseWriter).start();
        } else {
            ((BaseWriter.ListWriter)this.baseWriter).startList();
        }
    }

    boolean isMapWriter() {
        return this.baseWriter instanceof SingleMapWriter || this.baseWriter instanceof AbstractRepeatedMapWriter;
    }

    public void end() {
        if (this.isMapWriter()) {
            ((BaseWriter.MapWriter)this.baseWriter).end();
        } else {
            ((BaseWriter.ListWriter)this.baseWriter).endList();
        }
    }

    public String toString() {
        return this.converterName;
    }

    private <T> T getWriter(String name, BiFunction<BaseWriter.MapWriter, String, T> fromMap, Function<BaseWriter.ListWriter, T> fromList) {
        if (this.isMapWriter()) {
            return fromMap.apply((BaseWriter.MapWriter)this.baseWriter, name);
        }
        if (this.baseWriter instanceof BaseWriter.ListWriter) {
            return fromList.apply((BaseWriter.ListWriter)this.baseWriter);
        }
        throw new IllegalStateException(String.format("Parent writer with type [%s] is unsupported", this.baseWriter.getClass()));
    }

    private static /* synthetic */ Optional lambda$getConverterForType$35(LogicalTypeAnnotation.LogicalTypeAnnotationVisitor typeAnnotationVisitor, LogicalTypeAnnotation typeAnnotation) {
        return typeAnnotation.accept(typeAnnotationVisitor);
    }

    private static /* synthetic */ Optional lambda$getConverterForType$31(LogicalTypeAnnotation.LogicalTypeAnnotationVisitor typeAnnotationVisitor, LogicalTypeAnnotation typeAnnotation) {
        return typeAnnotation.accept(typeAnnotationVisitor);
    }

    private static class DrillIntermediateParquetGroupConverter
    extends DrillParquetGroupConverter {
        DrillIntermediateParquetGroupConverter(OutputMutator mutator, BaseWriter baseWriter, GroupType schema, Collection<SchemaPath> columns, OptionManager options, ParquetReaderUtility.DateCorruptionStatus containsCorruptedDates, boolean skipRepeated, String parentName) {
            super(mutator, baseWriter, schema, columns, options, containsCorruptedDates, skipRepeated, parentName);
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }
    }

    public static class DrillCorruptedDateConverter
    extends PrimitiveConverter {
        private DateWriter writer;
        private DateHolder holder = new DateHolder();

        public DrillCorruptedDateConverter(DateWriter writer) {
            this.writer = writer;
        }

        public void addInt(int value) {
            this.holder.value = ((long)value - 4881176L) * 86400000L;
            this.writer.write(this.holder);
        }
    }

    public static class DrillDateConverter
    extends PrimitiveConverter {
        private DateWriter writer;
        private DateHolder holder = new DateHolder();

        public DrillDateConverter(DateWriter writer) {
            this.writer = writer;
        }

        public void addInt(int value) {
            this.holder.value = (long)value * 86400000L;
            this.writer.write(this.holder);
        }
    }

    public static class CorruptionDetectingDateConverter
    extends PrimitiveConverter {
        private DateWriter writer;
        private DateHolder holder = new DateHolder();

        public CorruptionDetectingDateConverter(DateWriter writer) {
            this.writer = writer;
        }

        public void addInt(int value) {
            this.holder.value = value > ParquetReaderUtility.DATE_CORRUPTION_THRESHOLD ? ((long)value - 4881176L) * 86400000L : (long)value * 86400000L;
            this.writer.write(this.holder);
        }
    }

    public static class DrillTimeConverter
    extends PrimitiveConverter {
        private TimeWriter writer;
        private TimeHolder holder = new TimeHolder();

        public DrillTimeConverter(TimeWriter writer) {
            this.writer = writer;
        }

        public void addInt(int value) {
            this.holder.value = value;
            this.writer.write(this.holder);
        }
    }

    public static class DrillTimeStampMicrosConverter
    extends PrimitiveConverter {
        private final TimeStampWriter writer;
        private final TimeStampHolder holder = new TimeStampHolder();

        public DrillTimeStampMicrosConverter(TimeStampWriter writer) {
            this.writer = writer;
        }

        public void addLong(long value) {
            this.holder.value = value / 1000L;
            this.writer.write(this.holder);
        }
    }

    public static class DrillTimeMicrosConverter
    extends PrimitiveConverter {
        private final TimeWriter writer;
        private final TimeHolder holder = new TimeHolder();

        public DrillTimeMicrosConverter(TimeWriter writer) {
            this.writer = writer;
        }

        public void addLong(long value) {
            this.holder.value = (int)(value / 1000L);
            this.writer.write(this.holder);
        }
    }

    public static class DrillTimeStampConverter
    extends PrimitiveConverter {
        private TimeStampWriter writer;
        private TimeStampHolder holder = new TimeStampHolder();

        public DrillTimeStampConverter(TimeStampWriter writer) {
            this.writer = writer;
        }

        public void addLong(long value) {
            this.holder.value = value;
            this.writer.write(this.holder);
        }
    }

    public static class DrillFixedBinaryToTimeStampConverter
    extends PrimitiveConverter {
        private TimeStampWriter writer;
        private TimeStampHolder holder = new TimeStampHolder();

        public DrillFixedBinaryToTimeStampConverter(TimeStampWriter writer) {
            this.writer = writer;
        }

        public void addBinary(Binary value) {
            this.holder.value = ParquetReaderUtility.NanoTimeUtils.getDateTimeValueFromBinary(value, true);
            this.writer.write(this.holder);
        }
    }

    public static class DrillFixedBinaryToVarbinaryConverter
    extends PrimitiveConverter {
        private VarBinaryWriter writer;
        private VarBinaryHolder holder = new VarBinaryHolder();

        public DrillFixedBinaryToVarbinaryConverter(VarBinaryWriter writer, int length, DrillBuf buf) {
            this.writer = writer;
            this.holder.buffer = buf = buf.reallocIfNeeded(length);
            this.holder.start = 0;
            this.holder.end = length;
        }

        public void addBinary(Binary value) {
            this.holder.buffer.setBytes(0, value.toByteBuffer());
            this.writer.write(this.holder);
        }
    }

    public static class DrillFloat4Converter
    extends PrimitiveConverter {
        private Float4Writer writer;
        private Float4Holder holder = new Float4Holder();

        public DrillFloat4Converter(Float4Writer writer) {
            this.writer = writer;
        }

        public void addFloat(float value) {
            this.holder.value = value;
            this.writer.write(this.holder);
        }
    }

    public static class DrillFloat8Converter
    extends PrimitiveConverter {
        private Float8Writer writer;
        private Float8Holder holder = new Float8Holder();

        public DrillFloat8Converter(Float8Writer writer) {
            this.writer = writer;
        }

        public void addDouble(double value) {
            this.holder.value = value;
            this.writer.write(this.holder);
        }
    }

    public static class DrillBoolConverter
    extends PrimitiveConverter {
        private BitWriter writer;
        private BitHolder holder = new BitHolder();

        public DrillBoolConverter(BitWriter writer) {
            this.writer = writer;
        }

        public void addBoolean(boolean value) {
            this.holder.value = value ? 1 : 0;
            this.writer.write(this.holder);
        }
    }

    public static class DrillVarCharConverter
    extends PrimitiveConverter {
        private VarCharWriter writer;
        private VarCharHolder holder = new VarCharHolder();
        private DrillBuf buf;

        public DrillVarCharConverter(VarCharWriter writer, DrillBuf buf) {
            this.writer = writer;
            this.buf = buf;
        }

        public void addBinary(Binary value) {
            this.holder.buffer = this.buf = this.buf.reallocIfNeeded(value.length());
            this.buf.setBytes(0, value.toByteBuffer());
            this.holder.start = 0;
            this.holder.end = value.length();
            this.writer.write(this.holder);
        }
    }

    public static class DrillBigIntConverter
    extends PrimitiveConverter {
        private BigIntWriter writer;
        private BigIntHolder holder = new BigIntHolder();

        public DrillBigIntConverter(BigIntWriter writer) {
            this.writer = writer;
        }

        public void addLong(long value) {
            this.holder.value = value;
            this.writer.write(this.holder);
        }
    }

    public static class DrillIntConverter
    extends PrimitiveConverter {
        private IntWriter writer;
        private IntHolder holder = new IntHolder();

        public DrillIntConverter(IntWriter writer) {
            this.writer = writer;
        }

        public void addInt(int value) {
            this.holder.value = value;
            this.writer.write(this.holder);
        }
    }

    public static class DrillVarDecimalConverter
    extends PrimitiveConverter {
        private VarDecimalWriter writer;
        private VarDecimalHolder holder = new VarDecimalHolder();
        private DrillBuf buf;

        public DrillVarDecimalConverter(VarDecimalWriter writer, int precision, int scale, DrillBuf buf) {
            this.writer = writer;
            this.holder.scale = scale;
            this.holder.precision = precision;
            this.buf = buf;
        }

        public void addBinary(Binary value) {
            this.holder.buffer = this.buf.reallocIfNeeded(value.length());
            this.holder.buffer.setBytes(0, value.toByteBuffer());
            this.holder.start = 0;
            this.holder.end = value.length();
            this.writer.write(this.holder);
        }

        public void addInt(int value) {
            byte[] bytes = Ints.toByteArray(value);
            this.holder.buffer = this.buf.reallocIfNeeded(bytes.length);
            this.holder.buffer.setBytes(0, bytes);
            this.holder.start = 0;
            this.holder.end = bytes.length;
            this.writer.write(this.holder);
        }

        public void addLong(long value) {
            byte[] bytes = Longs.toByteArray(value);
            this.holder.buffer = this.buf.reallocIfNeeded(bytes.length);
            this.holder.buffer.setBytes(0, bytes);
            this.holder.start = 0;
            this.holder.end = bytes.length;
            this.writer.write(this.holder);
        }
    }

    public static class DrillVarBinaryConverter
    extends PrimitiveConverter {
        private VarBinaryWriter writer;
        private DrillBuf buf;
        private VarBinaryHolder holder = new VarBinaryHolder();

        public DrillVarBinaryConverter(VarBinaryWriter writer, DrillBuf buf) {
            this.writer = writer;
            this.buf = buf;
        }

        public void addBinary(Binary value) {
            this.holder.buffer = this.buf = this.buf.reallocIfNeeded(value.length());
            this.buf.setBytes(0, value.toByteBuffer());
            this.holder.start = 0;
            this.holder.end = value.length();
            this.writer.write(this.holder);
        }
    }

    public static class DrillFixedLengthByteArrayToInterval
    extends PrimitiveConverter {
        private final IntervalWriter writer;
        private final IntervalHolder holder = new IntervalHolder();

        public DrillFixedLengthByteArrayToInterval(IntervalWriter writer) {
            this.writer = writer;
        }

        public void addBinary(Binary value) {
            byte[] input = value.getBytes();
            this.holder.months = ParquetReaderUtility.getIntFromLEBytes(input, 0);
            this.holder.days = ParquetReaderUtility.getIntFromLEBytes(input, 4);
            this.holder.milliseconds = ParquetReaderUtility.getIntFromLEBytes(input, 8);
            this.writer.write(this.holder);
        }
    }
}

