/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.DrillVersionInfo;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.parquet.metadata.MetadataPathUtils;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V3;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class Metadata_V4 {

    public static class ParquetFileAndRowCountMetadata {
        ParquetFileMetadata_v4 fileMetadata;
        Map<ColumnTypeMetadata_v4.Key, Long> totalNullCountMap;
        long fileRowCount;

        public ParquetFileAndRowCountMetadata() {
        }

        public ParquetFileAndRowCountMetadata(ParquetFileMetadata_v4 fileMetadata, Map<ColumnTypeMetadata_v4.Key, Long> totalNullCountMap, long fileRowCount) {
            this.fileMetadata = fileMetadata;
            this.totalNullCountMap = totalNullCountMap;
            this.fileRowCount = fileRowCount;
        }

        public ParquetFileMetadata_v4 getFileMetadata() {
            return this.fileMetadata;
        }

        public long getFileRowCount() {
            return this.fileRowCount;
        }

        public Map<ColumnTypeMetadata_v4.Key, Long> getTotalNullCountMap() {
            return this.totalNullCountMap;
        }
    }

    public static class FileMetadata {
        @JsonProperty
        List<ParquetFileMetadata_v4> files;

        @JsonIgnore
        public List<ParquetFileMetadata_v4> getFiles() {
            return this.files;
        }

        @JsonIgnore
        public void assignFiles(List<? extends MetadataBase.ParquetFileMetadata> newFiles) {
            this.files = newFiles;
        }
    }

    @JsonTypeName(value="4.2")
    public static class MetadataSummary {
        @JsonProperty(value="metadata_version")
        private String metadataVersion;
        @JsonProperty
        ConcurrentHashMap<ColumnTypeMetadata_v4.Key, ColumnTypeMetadata_v4> columnTypeInfo = new ConcurrentHashMap();
        @JsonProperty
        List<Path> directories;
        @JsonProperty
        String drillVersion;
        @JsonProperty
        long totalRowCount = 0L;
        @JsonProperty
        boolean allColumnsInteresting = false;

        public MetadataSummary() {
        }

        public MetadataSummary(String metadataVersion, String drillVersion, boolean allColumnsInteresting) {
            this(metadataVersion, drillVersion, new ArrayList<Path>(), allColumnsInteresting);
        }

        public MetadataSummary(String metadataVersion, String drillVersion, List<Path> directories, boolean allColumnsInteresting) {
            this.metadataVersion = metadataVersion;
            this.drillVersion = drillVersion;
            this.directories = directories;
            this.allColumnsInteresting = allColumnsInteresting;
        }

        @JsonIgnore
        public ColumnTypeMetadata_v4 getColumnTypeInfo(String[] name) {
            return this.columnTypeInfo.get(new ColumnTypeMetadata_v4.Key(name));
        }

        @JsonIgnore
        public ColumnTypeMetadata_v4 getColumnTypeInfo(ColumnTypeMetadata_v4.Key key) {
            return this.columnTypeInfo.get(key);
        }

        @JsonIgnore
        public List<Path> getDirectories() {
            return this.directories;
        }

        @JsonIgnore
        public String getMetadataVersion() {
            return this.metadataVersion;
        }

        @JsonIgnore
        public boolean isAllColumnsInteresting() {
            return this.allColumnsInteresting;
        }

        @JsonIgnore
        public void setAllColumnsInteresting(boolean allColumnsInteresting) {
            this.allColumnsInteresting = allColumnsInteresting;
        }

        @JsonIgnore
        public void setTotalRowCount(Long totalRowCount) {
            this.totalRowCount = totalRowCount;
        }

        @JsonIgnore
        public Long getTotalRowCount() {
            return this.totalRowCount;
        }
    }

    public static class ColumnMetadata_v4
    extends Metadata_V3.ColumnMetadata_v3 {
        public ColumnMetadata_v4() {
        }

        public ColumnMetadata_v4(String[] name, PrimitiveType.PrimitiveTypeName primitiveType, Object minValue, Object maxValue, Long nulls) {
            super(name, primitiveType, minValue, maxValue, nulls);
        }
    }

    public static class ColumnTypeMetadata_v4
    extends MetadataBase.ColumnTypeMetadata {
        @JsonProperty
        public String[] name;
        @JsonProperty
        public PrimitiveType.PrimitiveTypeName primitiveType;
        @JsonProperty
        public OriginalType originalType;
        @JsonProperty
        public List<OriginalType> parentTypes;
        @JsonProperty
        public int precision;
        @JsonProperty
        public int scale;
        @JsonProperty
        public int repetitionLevel;
        @JsonProperty
        public int definitionLevel;
        @JsonProperty
        public long totalNullCount = 0L;
        @JsonProperty
        public boolean isInteresting = false;
        @JsonProperty
        public Type.Repetition repetition;
        @JsonIgnore
        private Key key;

        public ColumnTypeMetadata_v4() {
        }

        private ColumnTypeMetadata_v4(Builder builder) {
            this.name = builder.name;
            this.primitiveType = builder.primitiveType;
            this.originalType = builder.originalType;
            this.precision = builder.precision;
            this.scale = builder.scale;
            this.repetitionLevel = builder.repetitionLevel;
            this.definitionLevel = builder.definitionLevel;
            this.key = new Key(this.name);
            this.totalNullCount = builder.totalNullCount;
            this.isInteresting = builder.isInteresting;
            this.parentTypes = Collections.unmodifiableList(builder.parentTypes);
            this.repetition = builder.repetition;
        }

        @JsonIgnore
        private Key key() {
            return this.key;
        }

        @Override
        @JsonIgnore
        public PrimitiveType.PrimitiveTypeName getPrimitiveType() {
            return this.primitiveType;
        }

        @Override
        @JsonIgnore
        public String[] getName() {
            return this.name;
        }

        public static class Builder {
            private String[] name;
            private PrimitiveType.PrimitiveTypeName primitiveType;
            private OriginalType originalType;
            private List<OriginalType> parentTypes;
            private int precision;
            private int scale;
            private int repetitionLevel;
            private int definitionLevel;
            private long totalNullCount;
            private boolean isInteresting;
            private Type.Repetition repetition;

            public Builder name(String[] name) {
                this.name = name;
                return this;
            }

            public Builder primitiveType(PrimitiveType.PrimitiveTypeName primitiveType) {
                this.primitiveType = primitiveType;
                return this;
            }

            public Builder originalType(OriginalType originalType) {
                this.originalType = originalType;
                return this;
            }

            public Builder parentTypes(List<OriginalType> parentTypes) {
                this.parentTypes = parentTypes;
                return this;
            }

            public Builder precision(int precision) {
                this.precision = precision;
                return this;
            }

            public Builder scale(int scale) {
                this.scale = scale;
                return this;
            }

            public Builder repetitionLevel(int repetitionLevel) {
                this.repetitionLevel = repetitionLevel;
                return this;
            }

            public Builder definitionLevel(int definitionLevel) {
                this.definitionLevel = definitionLevel;
                return this;
            }

            public Builder totalNullCount(long totalNullCount) {
                this.totalNullCount = totalNullCount;
                return this;
            }

            public Builder interesting(boolean isInteresting) {
                this.isInteresting = isInteresting;
                return this;
            }

            public Builder repetition(Type.Repetition repetition) {
                this.repetition = repetition;
                return this;
            }

            public ColumnTypeMetadata_v4 build() {
                return new ColumnTypeMetadata_v4(this);
            }
        }

        public static class Key {
            private SchemaPath name;
            private int hashCode = 0;

            public Key(String[] name) {
                this.name = SchemaPath.getCompoundPath(name);
            }

            public Key(SchemaPath name) {
                this.name = new SchemaPath(name);
            }

            public int hashCode() {
                if (this.hashCode == 0) {
                    this.hashCode = this.name.hashCode();
                }
                return this.hashCode;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.name.equals(other.name);
            }

            public String toString() {
                return this.name.toString();
            }

            public static class DeSerializer
            extends KeyDeserializer {
                public Object deserializeKey(String key, DeserializationContext ctxt) {
                    if (key.contains("`")) {
                        return new Key(SchemaPath.parseFromString(key));
                    }
                    return new Key(key.split("\\."));
                }
            }
        }
    }

    public static class RowGroupMetadata_v4
    extends MetadataBase.RowGroupMetadata {
        @JsonProperty
        public Long start;
        @JsonProperty
        public Long length;
        @JsonProperty
        public Long rowCount;
        @JsonProperty
        public Map<String, Float> hostAffinity;
        @JsonProperty
        public List<ColumnMetadata_v4> columns;

        public RowGroupMetadata_v4() {
        }

        public RowGroupMetadata_v4(Long start, Long length, Long rowCount, Map<String, Float> hostAffinity, List<ColumnMetadata_v4> columns) {
            this.start = start;
            this.length = length;
            this.rowCount = rowCount;
            this.hostAffinity = hostAffinity;
            this.columns = columns;
        }

        @Override
        public Long getStart() {
            return this.start;
        }

        @Override
        public Long getLength() {
            return this.length;
        }

        @Override
        public Long getRowCount() {
            return this.rowCount;
        }

        @Override
        public Map<String, Float> getHostAffinity() {
            return this.hostAffinity;
        }

        @Override
        public List<? extends MetadataBase.ColumnMetadata> getColumns() {
            return this.columns;
        }
    }

    public static class ParquetFileMetadata_v4
    extends MetadataBase.ParquetFileMetadata {
        @JsonProperty
        public Path path;
        @JsonProperty
        public Long length;
        @JsonProperty
        public List<RowGroupMetadata_v4> rowGroups;

        public ParquetFileMetadata_v4() {
        }

        public ParquetFileMetadata_v4(Path path, Long length, List<RowGroupMetadata_v4> rowGroups) {
            this.path = path;
            this.length = length;
            this.rowGroups = rowGroups;
        }

        public String toString() {
            return String.format("path: %s rowGroups: %s", this.path, this.rowGroups);
        }

        @Override
        @JsonIgnore
        public Path getPath() {
            return this.path;
        }

        @Override
        @JsonIgnore
        public Long getLength() {
            return this.length;
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.RowGroupMetadata> getRowGroups() {
            return this.rowGroups;
        }
    }

    public static class ParquetTableMetadata_v4
    extends MetadataBase.ParquetTableMetadataBase {
        MetadataSummary metadataSummary = new MetadataSummary();
        FileMetadata fileMetadata = new FileMetadata();

        public ParquetTableMetadata_v4() {
            this.metadataSummary = new MetadataSummary("4.1", DrillVersionInfo.getVersion(), false);
        }

        public ParquetTableMetadata_v4(MetadataSummary metadataSummary) {
            this.metadataSummary = metadataSummary;
        }

        public ParquetTableMetadata_v4(MetadataSummary metadataSummary, FileMetadata fileMetadata) {
            this.metadataSummary = metadataSummary;
            this.fileMetadata = fileMetadata;
        }

        public ParquetTableMetadata_v4(String metadataVersion, MetadataBase.ParquetTableMetadataBase parquetTableMetadata, List<ParquetFileMetadata_v4> files, List<Path> directories, String drillVersion, long totalRowCount, boolean allColumnsInteresting) {
            this.metadataSummary.metadataVersion = metadataVersion;
            this.fileMetadata.files = files;
            this.metadataSummary.directories = directories;
            this.metadataSummary.columnTypeInfo = ((ParquetTableMetadata_v4)parquetTableMetadata).metadataSummary.columnTypeInfo;
            this.metadataSummary.drillVersion = drillVersion;
            this.metadataSummary.totalRowCount = totalRowCount;
            this.metadataSummary.allColumnsInteresting = allColumnsInteresting;
        }

        public ColumnTypeMetadata_v4 getColumnTypeInfo(String[] name) {
            return this.metadataSummary.getColumnTypeInfo(name);
        }

        @Override
        public List<Path> getDirectories() {
            return this.metadataSummary.getDirectories();
        }

        @Override
        public List<? extends MetadataBase.ParquetFileMetadata> getFiles() {
            return this.fileMetadata.getFiles();
        }

        @Override
        public String getMetadataVersion() {
            return this.metadataSummary.getMetadataVersion();
        }

        public void updateRelativePaths(String baseDir) {
            this.metadataSummary.directories = MetadataPathUtils.convertToAbsolutePaths(this.metadataSummary.directories, baseDir);
            this.fileMetadata.files = MetadataPathUtils.convertToFilesWithAbsolutePaths(this.fileMetadata.files, baseDir);
        }

        @Override
        public void assignFiles(List<? extends MetadataBase.ParquetFileMetadata> newFiles) {
            this.fileMetadata.assignFiles(newFiles);
        }

        @Override
        public boolean hasColumnMetadata() {
            return true;
        }

        @Override
        public PrimitiveType.PrimitiveTypeName getPrimitiveType(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).primitiveType;
        }

        @Override
        public OriginalType getOriginalType(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).originalType;
        }

        @Override
        public Integer getRepetitionLevel(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).repetitionLevel;
        }

        @Override
        public Integer getDefinitionLevel(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).definitionLevel;
        }

        @Override
        public Integer getScale(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).scale;
        }

        @Override
        public Integer getPrecision(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).precision;
        }

        @Override
        public boolean isRowGroupPrunable() {
            return true;
        }

        @Override
        public MetadataBase.ParquetTableMetadataBase clone() {
            return new ParquetTableMetadata_v4(this.metadataSummary, this.fileMetadata);
        }

        @Override
        public String getDrillVersion() {
            return this.metadataSummary.drillVersion;
        }

        @Override
        public Type.Repetition getRepetition(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).repetition;
        }

        public MetadataSummary getSummary() {
            return this.metadataSummary;
        }

        public long getTotalRowCount() {
            return this.metadataSummary.getTotalRowCount();
        }

        public long getTotalNullCount(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).totalNullCount;
        }

        public boolean isAllColumnsInteresting() {
            return this.metadataSummary.isAllColumnsInteresting();
        }

        public ConcurrentHashMap<ColumnTypeMetadata_v4.Key, ColumnTypeMetadata_v4> getColumnTypeInfoMap() {
            return this.metadataSummary.columnTypeInfo;
        }

        @Override
        public List<? extends MetadataBase.ColumnTypeMetadata> getColumnTypeInfoList() {
            return new ArrayList<ColumnTypeMetadata_v4>(this.metadataSummary.columnTypeInfo.values());
        }

        public void setTotalRowCount(long totalRowCount) {
            this.metadataSummary.setTotalRowCount(totalRowCount);
        }
    }
}

