/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class Metadata_V1 {

    public static class ColumnMetadata_v1
    extends MetadataBase.ColumnMetadata {
        @JsonProperty
        public SchemaPath name;
        @JsonProperty
        public PrimitiveType.PrimitiveTypeName primitiveType;
        @JsonProperty
        public OriginalType originalType;
        @JsonProperty
        public Long nulls;
        public Object max;
        public Object min;

        public ColumnMetadata_v1() {
        }

        public ColumnMetadata_v1(SchemaPath name, PrimitiveType.PrimitiveTypeName primitiveType, OriginalType originalType, Object max, Object min, Long nulls) {
            this.name = name;
            this.primitiveType = primitiveType;
            this.originalType = originalType;
            this.max = max;
            this.min = min;
            this.nulls = nulls;
        }

        @JsonProperty(value="min")
        public Object getMin() {
            if (this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY && this.min != null) {
                return new String(((Binary)this.min).getBytes(), StandardCharsets.UTF_8);
            }
            return this.min;
        }

        @JsonProperty(value="max")
        public Object getMax() {
            if (this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY && this.max != null) {
                return new String(((Binary)this.max).getBytes(), StandardCharsets.UTF_8);
            }
            return this.max;
        }

        @Override
        public PrimitiveType.PrimitiveTypeName getPrimitiveType() {
            return this.primitiveType;
        }

        @Override
        public OriginalType getOriginalType() {
            return this.originalType;
        }

        @Override
        @JsonProperty(value="min")
        public void setMin(Object min) {
            this.min = min;
        }

        @Override
        @JsonProperty(value="max")
        public void setMax(Object max) {
            this.max = max;
        }

        @Override
        public String[] getName() {
            String[] s = new String[1];
            String nameString = this.name.toString();
            s[0] = nameString.substring(1, nameString.length() - 1);
            return s;
        }

        @Override
        public Long getNulls() {
            return this.nulls;
        }

        @Override
        public boolean hasSingleValue(long rowCount) {
            if (this.nulls != null) {
                if (this.min != null) {
                    return Objects.deepEquals(this.min, this.max) && (this.nulls == 0L || this.nulls == rowCount);
                }
                return this.nulls == rowCount && this.max == null;
            }
            return false;
        }

        @Override
        public Object getMinValue() {
            return this.min;
        }

        @Override
        public Object getMaxValue() {
            return this.max;
        }
    }

    public static class RowGroupMetadata_v1
    extends MetadataBase.RowGroupMetadata {
        @JsonProperty
        public Long start;
        @JsonProperty
        public Long length;
        @JsonProperty
        public Long rowCount;
        @JsonProperty
        public Map<String, Float> hostAffinity;
        @JsonProperty
        public List<ColumnMetadata_v1> columns;

        public RowGroupMetadata_v1() {
        }

        public RowGroupMetadata_v1(Long start, Long length, Long rowCount, Map<String, Float> hostAffinity, List<ColumnMetadata_v1> columns) {
            this.start = start;
            this.length = length;
            this.rowCount = rowCount;
            this.hostAffinity = hostAffinity;
            this.columns = columns;
        }

        @Override
        public Long getStart() {
            return this.start;
        }

        @Override
        public Long getLength() {
            return this.length;
        }

        @Override
        public Long getRowCount() {
            return this.rowCount;
        }

        @Override
        public Map<String, Float> getHostAffinity() {
            return this.hostAffinity;
        }

        @Override
        public List<? extends MetadataBase.ColumnMetadata> getColumns() {
            return this.columns;
        }
    }

    public static class ParquetFileMetadata_v1
    extends MetadataBase.ParquetFileMetadata {
        @JsonProperty
        public Path path;
        @JsonProperty
        public Long length;
        @JsonProperty
        public List<RowGroupMetadata_v1> rowGroups;

        public ParquetFileMetadata_v1() {
        }

        public ParquetFileMetadata_v1(Path path, Long length, List<RowGroupMetadata_v1> rowGroups) {
            this.path = path;
            this.length = length;
            this.rowGroups = rowGroups;
        }

        public String toString() {
            return String.format("path: %s rowGroups: %s", this.path, this.rowGroups);
        }

        @Override
        @JsonIgnore
        public Path getPath() {
            return this.path;
        }

        @Override
        @JsonIgnore
        public Long getLength() {
            return this.length;
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.RowGroupMetadata> getRowGroups() {
            return this.rowGroups;
        }
    }

    @JsonTypeName(value="v1")
    public static class ParquetTableMetadata_v1
    extends MetadataBase.ParquetTableMetadataBase {
        @JsonProperty(value="metadata_version", access=JsonProperty.Access.WRITE_ONLY)
        private String metadataVersion;
        @JsonProperty
        List<ParquetFileMetadata_v1> files;
        @JsonProperty
        List<Path> directories;

        public ParquetTableMetadata_v1() {
        }

        public ParquetTableMetadata_v1(String metadataVersion, List<ParquetFileMetadata_v1> files, List<Path> directories) {
            this.metadataVersion = metadataVersion;
            this.files = files;
            this.directories = directories;
        }

        @Override
        @JsonIgnore
        public List<Path> getDirectories() {
            return this.directories;
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.ParquetFileMetadata> getFiles() {
            return this.files;
        }

        @Override
        @JsonIgnore
        public void assignFiles(List<? extends MetadataBase.ParquetFileMetadata> newFiles) {
            this.files = newFiles;
        }

        @Override
        public boolean hasColumnMetadata() {
            return false;
        }

        @Override
        @JsonIgnore
        public PrimitiveType.PrimitiveTypeName getPrimitiveType(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public OriginalType getOriginalType(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public Integer getRepetitionLevel(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public Integer getDefinitionLevel(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public Integer getScale(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public Integer getPrecision(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public boolean isRowGroupPrunable() {
            return false;
        }

        @Override
        @JsonIgnore
        public MetadataBase.ParquetTableMetadataBase clone() {
            return new ParquetTableMetadata_v1(this.metadataVersion, this.files, this.directories);
        }

        @Override
        @JsonIgnore
        public String getDrillVersion() {
            return null;
        }

        @Override
        @JsonIgnore
        public String getMetadataVersion() {
            return this.metadataVersion;
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.ColumnTypeMetadata> getColumnTypeInfoList() {
            return null;
        }
    }
}

