/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V1;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V2;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V3;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V4;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class MetadataBase {

    public static abstract class ColumnTypeMetadata {
        public abstract PrimitiveType.PrimitiveTypeName getPrimitiveType();

        public abstract String[] getName();
    }

    public static abstract class ColumnMetadata {
        @JsonIgnore
        public boolean isNumNullsSet() {
            Long nulls = this.getNulls();
            return nulls != null && nulls != -1L;
        }

        public abstract String[] getName();

        public abstract Long getNulls();

        public abstract boolean hasSingleValue(long var1);

        public abstract Object getMinValue();

        public abstract Object getMaxValue();

        public abstract void setMax(Object var1);

        public abstract void setMin(Object var1);

        public abstract PrimitiveType.PrimitiveTypeName getPrimitiveType();

        public abstract OriginalType getOriginalType();
    }

    public static abstract class RowGroupMetadata {
        @JsonIgnore
        public abstract Long getStart();

        @JsonIgnore
        public abstract Long getLength();

        @JsonIgnore
        public abstract Long getRowCount();

        @JsonIgnore
        public abstract Map<String, Float> getHostAffinity();

        @JsonIgnore
        public abstract List<? extends ColumnMetadata> getColumns();

        @JsonIgnore
        public boolean isEmpty() {
            Long rowCount = this.getRowCount();
            return rowCount != null && rowCount == 0L;
        }
    }

    public static abstract class ParquetFileMetadata {
        @JsonIgnore
        public abstract Path getPath();

        @JsonIgnore
        public abstract Long getLength();

        @JsonIgnore
        public abstract List<? extends RowGroupMetadata> getRowGroups();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="metadata_version", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Metadata_V1.ParquetTableMetadata_v1.class, name="v1"), @JsonSubTypes.Type(value=Metadata_V2.ParquetTableMetadata_v2.class, name="v2"), @JsonSubTypes.Type(value=Metadata_V3.ParquetTableMetadata_v3.class, name="v3"), @JsonSubTypes.Type(value=Metadata_V3.ParquetTableMetadata_v3.class, name="3.1"), @JsonSubTypes.Type(value=Metadata_V3.ParquetTableMetadata_v3.class, name="3.2"), @JsonSubTypes.Type(value=Metadata_V3.ParquetTableMetadata_v3.class, name="3.3"), @JsonSubTypes.Type(value=Metadata_V4.ParquetTableMetadata_v4.class, name="4.0"), @JsonSubTypes.Type(value=Metadata_V4.ParquetTableMetadata_v4.class, name="4.1"), @JsonSubTypes.Type(value=Metadata_V4.ParquetTableMetadata_v4.class, name="4.2")})
    public static abstract class ParquetTableMetadataBase {
        @JsonIgnore
        public abstract List<Path> getDirectories();

        @JsonIgnore
        public abstract List<? extends ParquetFileMetadata> getFiles();

        @JsonIgnore
        public abstract void assignFiles(List<? extends ParquetFileMetadata> var1);

        public abstract boolean hasColumnMetadata();

        @JsonIgnore
        public abstract PrimitiveType.PrimitiveTypeName getPrimitiveType(String[] var1);

        @JsonIgnore
        public abstract OriginalType getOriginalType(String[] var1);

        @JsonIgnore
        public abstract Integer getRepetitionLevel(String[] var1);

        @JsonIgnore
        public abstract Integer getDefinitionLevel(String[] var1);

        @JsonIgnore
        public abstract Integer getScale(String[] var1);

        @JsonIgnore
        public abstract Integer getPrecision(String[] var1);

        @JsonIgnore
        public abstract boolean isRowGroupPrunable();

        @JsonIgnore
        public abstract ParquetTableMetadataBase clone();

        @JsonIgnore
        public abstract String getDrillVersion();

        @JsonIgnore
        public abstract String getMetadataVersion();

        @JsonIgnore
        public abstract List<? extends ColumnTypeMetadata> getColumnTypeInfoList();

        @JsonIgnore
        public Type.Repetition getRepetition(String[] columnName) {
            return null;
        }
    }
}

