/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.collections.Collectors;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.DrillVersionInfo;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.serialization.PathSerDe;
import org.apache.drill.exec.store.TimedCallable;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.MetadataContext;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.metadata.FileMetadataCollector;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.parquet.metadata.MetadataPathUtils;
import org.apache.drill.exec.store.parquet.metadata.MetadataVersion;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V2;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V3;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V4;
import org.apache.drill.exec.store.parquet.metadata.ParquetTableMetadataDirs;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    private static final Logger logger = LoggerFactory.getLogger(Metadata.class);
    public static final String[] OLD_METADATA_FILENAMES = new String[]{".drill.parquet_metadata", ".drill.parquet_metadata.v2"};
    public static final String OLD_METADATA_FILENAME = ".drill.parquet_metadata";
    public static final String METADATA_DIRECTORIES_FILENAME = ".drill.parquet_metadata_directories";
    public static final String METADATA_FILENAME = ".drill.parquet_file_metadata.v4";
    public static final String METADATA_SUMMARY_FILENAME = ".drill.parquet_summary_metadata.v4";
    public static final String[] CURRENT_METADATA_FILENAMES = new String[]{".drill.parquet_summary_metadata.v4", ".drill.parquet_file_metadata.v4"};
    public static final Long DEFAULT_NULL_COUNT = 0L;
    public static final Long NULL_COUNT_NOT_EXISTS = -1L;
    private final ParquetReaderConfig readerConfig;
    private MetadataBase.ParquetTableMetadataBase parquetTableMetadata;
    private ParquetTableMetadataDirs parquetTableMetadataDirs;

    private Metadata(ParquetReaderConfig readerConfig) {
        this.readerConfig = readerConfig;
    }

    public static void createMeta(FileSystem fs, Path path, ParquetReaderConfig readerConfig, boolean allColumnsInteresting, Set<SchemaPath> columnSet) throws IOException {
        Metadata metadata = new Metadata(readerConfig);
        metadata.createMetaFilesRecursivelyAsProcessUser(path, fs, allColumnsInteresting, columnSet, false);
    }

    public static Metadata_V4.ParquetTableMetadata_v4 getParquetTableMetadata(FileSystem fs, Path path, ParquetReaderConfig readerConfig) throws IOException {
        Metadata metadata = new Metadata(readerConfig);
        return metadata.getParquetTableMetadata(path, fs);
    }

    public static Metadata_V4.ParquetTableMetadata_v4 getParquetTableMetadata(Map<FileStatus, FileSystem> fileStatusMap, ParquetReaderConfig readerConfig) throws IOException {
        Metadata metadata = new Metadata(readerConfig);
        return metadata.getParquetTableMetadata(fileStatusMap);
    }

    public static MetadataBase.ParquetTableMetadataBase readBlockMeta(FileSystem fs, List<Path> paths, MetadataContext metaContext, ParquetReaderConfig readerConfig) {
        Metadata metadata = new Metadata(readerConfig);
        if (paths.isEmpty()) {
            metaContext.setMetadataCacheCorrupted(true);
        }
        for (Path path : paths) {
            if (Metadata.ignoreReadingMetadata(metaContext, path)) {
                return null;
            }
            metadata.readBlockMeta(path, false, metaContext, fs);
        }
        return metadata.parquetTableMetadata;
    }

    public static ParquetTableMetadataDirs readMetadataDirs(FileSystem fs, Path path, MetadataContext metaContext, ParquetReaderConfig readerConfig) {
        if (Metadata.ignoreReadingMetadata(metaContext, path)) {
            return null;
        }
        Metadata metadata = new Metadata(readerConfig);
        metadata.readBlockMeta(path, true, metaContext, fs);
        return metadata.parquetTableMetadataDirs;
    }

    private static boolean ignoreReadingMetadata(MetadataContext metaContext, Path path) {
        if (metaContext.isMetadataCacheCorrupted()) {
            logger.warn("Ignoring of reading '{}' metadata file. Parquet metadata cache files are unsupported or corrupted. Query performance may be slow. Make sure the cache files are up-to-date by running the 'REFRESH TABLE METADATA' command", (Object)path);
            return true;
        }
        return false;
    }

    private Pair<Metadata_V4.ParquetTableMetadata_v4, ParquetTableMetadataDirs> createMetaFilesRecursivelyAsProcessUser(Path path, FileSystem fs, boolean allColumnsInteresting, Set<SchemaPath> columnSet, boolean autoRefreshTriggered) throws IOException {
        DrillFileSystem processUserFileSystem = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), fs.getConf());
        if (autoRefreshTriggered) {
            allColumnsInteresting = this.isAllColumnsInteresting(fs, path, true);
            columnSet = null;
            if (!allColumnsInteresting) {
                columnSet = this.getInterestingColumns(fs, path, true);
            }
        }
        return this.createMetaFilesRecursively(path, processUserFileSystem, allColumnsInteresting, columnSet);
    }

    /*
     * WARNING - void declaration
     */
    private Pair<Metadata_V4.ParquetTableMetadata_v4, ParquetTableMetadataDirs> createMetaFilesRecursively(Path path, FileSystem fs, boolean allColumnsInteresting, Set<SchemaPath> columnSet) throws IOException {
        void var17_22;
        String[] childFileAndRowCountMetadata;
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        ArrayList<? extends MetadataBase.ParquetFileMetadata> metaDataList = Lists.newArrayList();
        ArrayList<Path> directoryList = Lists.newArrayList();
        ConcurrentHashMap<Metadata_V4.ColumnTypeMetadata_v4.Key, Metadata_V4.ColumnTypeMetadata_v4> columnTypeInfoSet = new ConcurrentHashMap<Metadata_V4.ColumnTypeMetadata_v4.Key, Metadata_V4.ColumnTypeMetadata_v4>();
        FileStatus fileStatus = fs.getFileStatus(path);
        long dirTotalRowCount = 0L;
        assert (fileStatus.isDirectory()) : "Expected directory";
        LinkedHashMap<FileStatus, FileSystem> childFiles = new LinkedHashMap<FileStatus, FileSystem>();
        for (FileStatus file : DrillFileSystemUtil.listAll(fs, path, false, new PathFilter[0])) {
            if (file.isDirectory()) {
                Metadata_V4.ParquetTableMetadata_v4 subTableMetadata = (Metadata_V4.ParquetTableMetadata_v4)this.createMetaFilesRecursively(file.getPath(), fs, allColumnsInteresting, columnSet).getLeft();
                ConcurrentHashMap<Metadata_V4.ColumnTypeMetadata_v4.Key, Metadata_V4.ColumnTypeMetadata_v4> subTableColumnTypeInfo = subTableMetadata.getColumnTypeInfoMap();
                metaDataList.addAll(subTableMetadata.getFiles());
                directoryList.addAll(subTableMetadata.getDirectories());
                directoryList.add(file.getPath());
                if (columnTypeInfoSet.isEmpty()) {
                    columnTypeInfoSet.putAll(subTableColumnTypeInfo);
                } else {
                    for (Metadata_V4.ColumnTypeMetadata_v4.Key key : subTableColumnTypeInfo.keySet()) {
                        Metadata_V4.ColumnTypeMetadata_v4 columnTypeMetadata_v4 = (Metadata_V4.ColumnTypeMetadata_v4)columnTypeInfoSet.get(key);
                        if (columnTypeMetadata_v4 == null) {
                            columnTypeMetadata_v4 = (Metadata_V4.ColumnTypeMetadata_v4)subTableColumnTypeInfo.get(key);
                        } else {
                            columnTypeMetadata_v4.totalNullCount = ((Metadata_V4.ColumnTypeMetadata_v4)subTableColumnTypeInfo.get((Object)key)).totalNullCount < 0L || columnTypeMetadata_v4.totalNullCount < 0L ? NULL_COUNT_NOT_EXISTS : (columnTypeMetadata_v4.totalNullCount += ((Metadata_V4.ColumnTypeMetadata_v4)subTableColumnTypeInfo.get((Object)key)).totalNullCount);
                        }
                        columnTypeInfoSet.put(key, columnTypeMetadata_v4);
                    }
                }
                dirTotalRowCount += subTableMetadata.getTotalRowCount();
                continue;
            }
            childFiles.put(file, fs);
        }
        Metadata_V4.MetadataSummary metadataSummary = new Metadata_V4.MetadataSummary(MetadataVersion.Constants.SUPPORTED_VERSIONS.last().toString(), DrillVersionInfo.getVersion(), allColumnsInteresting || columnSet == null);
        Metadata_V4.ParquetTableMetadata_v4 parquetTableMetadata = new Metadata_V4.ParquetTableMetadata_v4(metadataSummary);
        if (childFiles.size() > 0) {
            childFileAndRowCountMetadata = this.getParquetFileMetadata_v4(parquetTableMetadata, childFiles, allColumnsInteresting, columnSet);
            if (columnTypeInfoSet.isEmpty()) {
                columnTypeInfoSet.putAll(parquetTableMetadata.getColumnTypeInfoMap());
            }
            for (Metadata_V4.ParquetFileAndRowCountMetadata parquetFileAndRowCountMetadata : childFileAndRowCountMetadata) {
                metaDataList.add(parquetFileAndRowCountMetadata.getFileMetadata());
                dirTotalRowCount += parquetFileAndRowCountMetadata.getFileRowCount();
                Map<Metadata_V4.ColumnTypeMetadata_v4.Key, Long> totalNullCountMap = parquetFileAndRowCountMetadata.getTotalNullCountMap();
                for (Metadata_V4.ColumnTypeMetadata_v4.Key column : totalNullCountMap.keySet()) {
                    Metadata_V4.ColumnTypeMetadata_v4 columnTypeMetadata_v4 = (Metadata_V4.ColumnTypeMetadata_v4)columnTypeInfoSet.get(column);
                    if (columnTypeMetadata_v4 == null) {
                        columnTypeMetadata_v4 = parquetTableMetadata.getColumnTypeInfoMap().get(column);
                    }
                    columnTypeMetadata_v4.totalNullCount = columnTypeMetadata_v4.totalNullCount < 0L || totalNullCountMap.get(column) < 0L ? NULL_COUNT_NOT_EXISTS : (columnTypeMetadata_v4.totalNullCount += totalNullCountMap.get(column).longValue());
                    columnTypeInfoSet.put(column, columnTypeMetadata_v4);
                }
            }
        }
        metadataSummary.directories = directoryList;
        parquetTableMetadata.assignFiles(metaDataList);
        if (metadataSummary.columnTypeInfo == null) {
            metadataSummary.columnTypeInfo = new ConcurrentHashMap();
        }
        metadataSummary.columnTypeInfo.putAll(columnTypeInfoSet);
        metadataSummary.allColumnsInteresting = allColumnsInteresting;
        metadataSummary.totalRowCount = dirTotalRowCount;
        parquetTableMetadata.metadataSummary = metadataSummary;
        childFileAndRowCountMetadata = OLD_METADATA_FILENAMES;
        int subTableColumnTypeInfo = childFileAndRowCountMetadata.length;
        boolean bl = false;
        while (var17_22 < subTableColumnTypeInfo) {
            String oldName = childFileAndRowCountMetadata[var17_22];
            fs.delete(new Path(path, oldName), false);
            ++var17_22;
        }
        Metadata_V4.ParquetTableMetadata_v4 metadataTableWithRelativePaths = MetadataPathUtils.createMetadataWithRelativePaths(parquetTableMetadata, path);
        this.writeFile(metadataTableWithRelativePaths.fileMetadata, new Path(path, METADATA_FILENAME), fs);
        this.writeFile(metadataTableWithRelativePaths.getSummary(), new Path(path, METADATA_SUMMARY_FILENAME), fs);
        Metadata_V4.MetadataSummary metadataSummaryWithRelativePaths = metadataTableWithRelativePaths.getSummary();
        this.writeFile(new ParquetTableMetadataDirs(metadataSummaryWithRelativePaths.directories), new Path(path, METADATA_DIRECTORIES_FILENAME), fs);
        if (timer != null) {
            logger.debug("Creating metadata files recursively took {} ms", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
            timer.stop();
        }
        return Pair.of((Object)parquetTableMetadata, (Object)new ParquetTableMetadataDirs(directoryList));
    }

    private Metadata_V4.ParquetTableMetadata_v4 getParquetTableMetadata(Path path, FileSystem fs) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(path);
        Stopwatch watch = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        if (fileStatus.isFile()) {
            fileStatuses.add(fileStatus);
        } else {
            fileStatuses.addAll(DrillFileSystemUtil.listFiles(fs, path, true, new PathFilter[0]));
        }
        if (watch != null) {
            logger.debug("Took {} ms to get file statuses", (Object)watch.elapsed(TimeUnit.MILLISECONDS));
            watch.reset();
            watch.start();
        }
        Map fileStatusMap = fileStatuses.stream().collect(java.util.stream.Collectors.toMap(Function.identity(), s -> fs, (oldFs, newFs) -> newFs, LinkedHashMap::new));
        Metadata_V4.ParquetTableMetadata_v4 metadata_v4 = this.getParquetTableMetadata(fileStatusMap);
        if (watch != null) {
            logger.debug("Took {} ms to read file metadata", (Object)watch.elapsed(TimeUnit.MILLISECONDS));
            watch.stop();
        }
        return metadata_v4;
    }

    private Metadata_V4.ParquetTableMetadata_v4 getParquetTableMetadata(Map<FileStatus, FileSystem> fileStatusMap) throws IOException {
        Metadata_V4.MetadataSummary tableMetadataSummary = new Metadata_V4.MetadataSummary(MetadataVersion.Constants.SUPPORTED_VERSIONS.last().toString(), DrillVersionInfo.getVersion(), new ArrayList<Path>(), true);
        Metadata_V4.ParquetTableMetadata_v4 tableMetadata = new Metadata_V4.ParquetTableMetadata_v4(tableMetadataSummary);
        List<Metadata_V4.ParquetFileAndRowCountMetadata> parquetFileAndRowCountMetadata = this.getParquetFileMetadata_v4(tableMetadata, fileStatusMap, true, null);
        ArrayList<Metadata_V4.ParquetFileMetadata_v4> parquetFileMetadata = new ArrayList<Metadata_V4.ParquetFileMetadata_v4>();
        for (Metadata_V4.ParquetFileAndRowCountMetadata fileAndGlobalMetadata : parquetFileAndRowCountMetadata) {
            parquetFileMetadata.add(fileAndGlobalMetadata.getFileMetadata());
        }
        tableMetadata.assignFiles(parquetFileMetadata);
        return tableMetadata;
    }

    private List<Metadata_V4.ParquetFileAndRowCountMetadata> getParquetFileMetadata_v4(Metadata_V4.ParquetTableMetadata_v4 parquetTableMetadata_v4, Map<FileStatus, FileSystem> fileStatusMap, boolean allColumnsInteresting, Set<SchemaPath> columnSet) throws IOException {
        return TimedCallable.run("Fetch parquet metadata", logger, Collectors.toList(fileStatusMap, (fileStatus, fileSystem) -> new MetadataGatherer(parquetTableMetadata_v4, (FileStatus)fileStatus, (FileSystem)fileSystem, allColumnsInteresting, columnSet)), 16);
    }

    private Metadata_V4.ParquetFileAndRowCountMetadata getParquetFileMetadata_v4(Metadata_V4.ParquetTableMetadata_v4 parquetTableMetadata, FileStatus file, FileSystem fs, boolean allColumnsInteresting, Set<SchemaPath> columnSet, ParquetReaderConfig readerConfig) throws IOException, InterruptedException {
        return Metadata.getParquetFileMetadata_v4(parquetTableMetadata, null, file, fs, allColumnsInteresting, false, columnSet, readerConfig);
    }

    public static Metadata_V4.ParquetFileAndRowCountMetadata getParquetFileMetadata_v4(Metadata_V4.ParquetTableMetadata_v4 parquetTableMetadata, ParquetMetadata footer, FileStatus file, FileSystem fs, boolean allColumnsInteresting, boolean skipNonInteresting, Set<SchemaPath> columnSet, ParquetReaderConfig readerConfig) throws IOException, InterruptedException {
        ParquetMetadata metadata = footer;
        if (metadata == null) {
            UserGroupInformation processUserUgi = ImpersonationUtil.getProcessUserUGI();
            Configuration conf = new Configuration(fs.getConf());
            try {
                metadata = (ParquetMetadata)processUserUgi.doAs(() -> {
                    try (ParquetFileReader parquetFileReader = ParquetFileReader.open((InputFile)HadoopInputFile.fromStatus((FileStatus)file, (Configuration)conf), (ParquetReadOptions)readerConfig.toReadOptions());){
                        ParquetMetadata parquetMetadata = parquetFileReader.getFooter();
                        return parquetMetadata;
                    }
                });
            }
            catch (Exception e) {
                logger.error("Exception while reading footer of parquet file [Details - path: {}, owner: {}] as process user {}", new Object[]{file.getPath(), file.getOwner(), processUserUgi.getShortUserName(), e});
                throw e;
            }
        }
        FileMetadataCollector metadataCollector = new FileMetadataCollector(metadata, file, fs, allColumnsInteresting, skipNonInteresting, columnSet, readerConfig);
        parquetTableMetadata.metadataSummary.columnTypeInfo.putAll(metadataCollector.getColumnTypeInfo());
        return metadataCollector.getFileMetadata();
    }

    private void writeFile(Object parquetMetadata, Path p, FileSystem fs) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        jsonFactory.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Path.class, (JsonSerializer)new PathSerDe.Se());
        if (parquetMetadata instanceof Metadata_V4.FileMetadata) {
            module.addSerializer(Metadata_V4.ColumnMetadata_v4.class, (JsonSerializer)new Metadata_V3.ColumnMetadata_v3.Serializer());
        }
        ObjectMapper mapper = ((JsonMapper.Builder)JacksonUtils.createJsonMapperBuilder(jsonFactory).addModule((Module)module)).build();
        FSDataOutputStream os = fs.create(p);
        mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, parquetMetadata);
        os.flush();
        os.close();
    }

    private void readBlockMeta(Path path, boolean dirsOnly, MetadataContext metaContext, FileSystem fs) {
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        Path metadataParentDir = Path.getPathWithoutSchemeAndAuthority((Path)path.getParent());
        String metadataParentDirPath = metadataParentDir.toUri().getPath();
        ObjectMapper mapper = JacksonUtils.createObjectMapper();
        SimpleModule serialModule = new SimpleModule();
        serialModule.addDeserializer(SchemaPath.class, (JsonDeserializer)new SchemaPath.De());
        serialModule.addKeyDeserializer(Metadata_V2.ColumnTypeMetadata_v2.Key.class, (KeyDeserializer)new Metadata_V2.ColumnTypeMetadata_v2.Key.DeSerializer());
        serialModule.addKeyDeserializer(Metadata_V3.ColumnTypeMetadata_v3.Key.class, (KeyDeserializer)new Metadata_V3.ColumnTypeMetadata_v3.Key.DeSerializer());
        serialModule.addKeyDeserializer(Metadata_V4.ColumnTypeMetadata_v4.Key.class, (KeyDeserializer)new Metadata_V4.ColumnTypeMetadata_v4.Key.DeSerializer());
        AfterburnerModule module = new AfterburnerModule();
        module.setUseOptimizedBeanDeserializer(true);
        boolean isFileMetadata = path.toString().endsWith(METADATA_FILENAME);
        boolean isSummaryFile = path.toString().endsWith(METADATA_SUMMARY_FILENAME);
        mapper.registerModule((Module)serialModule);
        mapper.registerModule((Module)module);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try (FSDataInputStream is = fs.open(path);){
            boolean newMetadata = false;
            boolean alreadyCheckedModification = metaContext.getStatus(metadataParentDir);
            if (dirsOnly) {
                this.parquetTableMetadataDirs = (ParquetTableMetadataDirs)mapper.readValue((InputStream)is, ParquetTableMetadataDirs.class);
                if (timer != null) {
                    logger.debug("Took {} ms to read directories from directory cache file", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
                    timer.stop();
                }
                this.parquetTableMetadataDirs.updateRelativePaths(metadataParentDirPath);
                if (!alreadyCheckedModification && this.tableModified(this.parquetTableMetadataDirs.getDirectories(), path, metadataParentDir, metaContext, fs)) {
                    this.parquetTableMetadataDirs = (ParquetTableMetadataDirs)this.createMetaFilesRecursivelyAsProcessUser(Path.getPathWithoutSchemeAndAuthority((Path)path.getParent()), fs, true, null, true).getRight();
                    newMetadata = true;
                }
            } else {
                List<? extends MetadataBase.ParquetFileMetadata> files;
                if (isFileMetadata) {
                    this.parquetTableMetadata.assignFiles(((Metadata_V4.FileMetadata)mapper.readValue((InputStream)is, Metadata_V4.FileMetadata.class)).getFiles());
                    if (new MetadataVersion(this.parquetTableMetadata.getMetadataVersion()).isAtLeast(4, 0)) {
                        ((Metadata_V4.ParquetTableMetadata_v4)this.parquetTableMetadata).updateRelativePaths(metadataParentDirPath);
                    }
                    if (!alreadyCheckedModification && this.tableModified(this.parquetTableMetadata.getDirectories(), path, metadataParentDir, metaContext, fs)) {
                        this.parquetTableMetadata = (MetadataBase.ParquetTableMetadataBase)this.createMetaFilesRecursivelyAsProcessUser(Path.getPathWithoutSchemeAndAuthority((Path)path.getParent()), fs, true, null, true).getLeft();
                        newMetadata = true;
                    }
                } else if (isSummaryFile) {
                    Metadata_V4.MetadataSummary metadataSummary = (Metadata_V4.MetadataSummary)mapper.readValue((InputStream)is, Metadata_V4.MetadataSummary.class);
                    this.parquetTableMetadata = new Metadata_V4.ParquetTableMetadata_v4(metadataSummary);
                } else {
                    this.parquetTableMetadata = (MetadataBase.ParquetTableMetadataBase)mapper.readValue((InputStream)is, MetadataBase.ParquetTableMetadataBase.class);
                    if (new MetadataVersion(this.parquetTableMetadata.getMetadataVersion()).isAtLeast(3, 0)) {
                        ((Metadata_V3.ParquetTableMetadata_v3)this.parquetTableMetadata).updateRelativePaths(metadataParentDirPath);
                    }
                    if (!alreadyCheckedModification && this.tableModified(this.parquetTableMetadata.getDirectories(), path, metadataParentDir, metaContext, fs)) {
                        this.parquetTableMetadata = (MetadataBase.ParquetTableMetadataBase)this.createMetaFilesRecursivelyAsProcessUser(Path.getPathWithoutSchemeAndAuthority((Path)path.getParent()), fs, true, null, true).getLeft();
                        newMetadata = true;
                    }
                }
                if (timer != null) {
                    logger.debug("Took {} ms to read metadata from cache file", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
                    timer.stop();
                }
                if (!isSummaryFile && (files = this.parquetTableMetadata.getFiles()) != null) {
                    for (MetadataBase.ParquetFileMetadata parquetFileMetadata : files) {
                        List<? extends MetadataBase.RowGroupMetadata> rowGroups = parquetFileMetadata.getRowGroups();
                        if (rowGroups.size() == 1) continue;
                        rowGroups.removeIf(r -> r.getRowCount() == 0L);
                    }
                }
                if (newMetadata) {
                    metaContext.clear();
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to read '{}' metadata file", (Object)path, (Object)e);
            metaContext.setMetadataCacheCorrupted(true);
        }
    }

    private Set<SchemaPath> getInterestingColumns(FileSystem fs, Path metadataParentDir, boolean autoRefreshTriggered) {
        Metadata_V4.MetadataSummary metadataSummary = Metadata.getSummary(fs, metadataParentDir, autoRefreshTriggered, null);
        if (metadataSummary == null) {
            return null;
        }
        HashSet<SchemaPath> interestingColumns = new HashSet<SchemaPath>();
        for (Metadata_V4.ColumnTypeMetadata_v4 columnTypeMetadata_v4 : metadataSummary.columnTypeInfo.values()) {
            if (!columnTypeMetadata_v4.isInteresting) continue;
            interestingColumns.add(SchemaPath.getSimplePath(SchemaPath.getCompoundPath(columnTypeMetadata_v4.name).getRootSegmentPath()));
        }
        return interestingColumns;
    }

    private boolean isAllColumnsInteresting(FileSystem fs, Path metadataParentDir, boolean autoRefreshTriggered) {
        Metadata_V4.MetadataSummary metadataSummary = Metadata.getSummary(fs, metadataParentDir, autoRefreshTriggered, null);
        if (metadataSummary == null) {
            return true;
        }
        return metadataSummary.isAllColumnsInteresting();
    }

    public static Path getSummaryFileName(Path metadataParentDir) {
        return new Path(metadataParentDir, METADATA_SUMMARY_FILENAME);
    }

    public static Path getDirFileName(Path metadataParentDir) {
        return new Path(metadataParentDir, METADATA_DIRECTORIES_FILENAME);
    }

    private static Path getFileMetadataFileName(Path metadataParentDir) {
        return new Path(metadataParentDir, METADATA_FILENAME);
    }

    private static boolean metadataExists(FileSystem fs, Path metadataParentDir) throws IOException {
        Path summaryFile = new Path(metadataParentDir, METADATA_SUMMARY_FILENAME);
        Path metadataDirFile = new Path(metadataParentDir, METADATA_DIRECTORIES_FILENAME);
        Path fileMetadataFile = new Path(metadataParentDir, METADATA_FILENAME);
        return fs.exists(summaryFile) || fs.exists(metadataDirFile) || fs.exists(fileMetadataFile);
    }

    public static Metadata_V4.MetadataSummary getSummary(FileSystem fs, Path metadataParentDir, boolean autoRefreshTriggered, ParquetReaderConfig readerConfig) {
        Path summaryFile = Metadata.getSummaryFileName(metadataParentDir);
        Path metadataDirFile = Metadata.getDirFileName(metadataParentDir);
        MetadataContext metaContext = new MetadataContext();
        try {
            if (!autoRefreshTriggered && !Metadata.metadataExists(fs, metadataParentDir)) {
                logger.debug("Metadata doesn't exist in {}", (Object)metadataParentDir);
                return null;
            }
            if (autoRefreshTriggered && !fs.exists(summaryFile)) {
                logger.debug("Metadata Summary file {} does not exist", (Object)summaryFile);
                return null;
            }
            if (!autoRefreshTriggered) {
                Metadata metadata = new Metadata(readerConfig);
                if (!fs.exists(metadataDirFile)) {
                    return null;
                }
                ParquetTableMetadataDirs metadataDirs = Metadata.readMetadataDirs(fs, metadataDirFile, metaContext, readerConfig);
                if (metadata.tableModified(metadataDirs.getDirectories(), summaryFile, metadataParentDir, metaContext, fs)) {
                    Metadata_V4.ParquetTableMetadata_v4 parquetTableMetadata = (Metadata_V4.ParquetTableMetadata_v4)metadata.createMetaFilesRecursivelyAsProcessUser(Path.getPathWithoutSchemeAndAuthority((Path)summaryFile.getParent()), fs, true, null, true).getLeft();
                    return parquetTableMetadata.getSummary();
                }
            }
            SimpleModule serialModule = new SimpleModule();
            serialModule.addDeserializer(SchemaPath.class, (JsonDeserializer)new SchemaPath.De());
            serialModule.addKeyDeserializer(Metadata_V4.ColumnTypeMetadata_v4.Key.class, (KeyDeserializer)new Metadata_V4.ColumnTypeMetadata_v4.Key.DeSerializer());
            AfterburnerModule module = new AfterburnerModule();
            module.setUseOptimizedBeanDeserializer(true);
            ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JacksonUtils.createJsonMapperBuilder().addModule((Module)serialModule)).addModule((Module)module)).build();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            FSDataInputStream is = fs.open(summaryFile);
            return (Metadata_V4.MetadataSummary)mapper.readValue((InputStream)is, Metadata_V4.MetadataSummary.class);
        }
        catch (IOException e) {
            logger.debug("Failed to read '{}' summary metadata file", (Object)summaryFile, (Object)e);
            return null;
        }
    }

    private boolean tableModified(List<Path> directories, Path metaFilePath, Path parentDir, MetadataContext metaContext, FileSystem fs) throws IOException {
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        metaContext.setStatus(parentDir);
        long metaFileModifyTime = fs.getFileStatus(metaFilePath).getModificationTime();
        FileStatus directoryStatus = fs.getFileStatus(parentDir);
        int numDirs = 1;
        if (directoryStatus.getModificationTime() > metaFileModifyTime) {
            return this.logAndStopTimer(true, directoryStatus.getPath().toString(), timer, numDirs);
        }
        boolean isModified = false;
        for (Path directory : directories) {
            ++numDirs;
            metaContext.setStatus(directory);
            directoryStatus = fs.getFileStatus(directory);
            if (directoryStatus.getModificationTime() <= metaFileModifyTime) continue;
            isModified = true;
            break;
        }
        return this.logAndStopTimer(isModified, directoryStatus.getPath().toString(), timer, numDirs);
    }

    private boolean logAndStopTimer(boolean isModified, String directoryName, Stopwatch timer, int numDirectories) {
        if (timer != null) {
            logger.debug("{} directory was modified. Took {} ms to check modification time of {} directories", new Object[]{isModified ? directoryName : "No", timer.elapsed(TimeUnit.MILLISECONDS), numDirectories});
            timer.stop();
        }
        return isModified;
    }

    private class MetadataGatherer
    extends TimedCallable<Metadata_V4.ParquetFileAndRowCountMetadata> {
        private final Metadata_V4.ParquetTableMetadata_v4 parquetTableMetadata;
        private final FileStatus fileStatus;
        private final FileSystem fs;
        private final boolean allColumnsInteresting;
        private final Set<SchemaPath> columnSet;

        MetadataGatherer(Metadata_V4.ParquetTableMetadata_v4 parquetTableMetadata, FileStatus fileStatus, FileSystem fs, boolean allColumnsInteresting, Set<SchemaPath> columnSet) {
            this.parquetTableMetadata = parquetTableMetadata;
            this.fileStatus = fileStatus;
            this.fs = fs;
            this.allColumnsInteresting = allColumnsInteresting;
            this.columnSet = columnSet;
        }

        @Override
        protected Metadata_V4.ParquetFileAndRowCountMetadata runInner() throws Exception {
            return Metadata.this.getParquetFileMetadata_v4(this.parquetTableMetadata, this.fileStatus, this.fs, this.allColumnsInteresting, this.columnSet, Metadata.this.readerConfig);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.fileStatus.getPath()).toString();
        }
    }
}

