/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.decimal;

import io.netty.buffer.DrillBuf;
import java.util.Arrays;
import org.apache.drill.exec.store.parquet.decimal.DecimalValueWriter;
import org.apache.drill.shaded.guava.com.google.common.primitives.Ints;
import org.apache.parquet.io.api.RecordConsumer;

public class Int32DecimalParquetValueWriter
extends DecimalValueWriter {
    @Override
    public void writeValue(RecordConsumer consumer, DrillBuf buffer, int start, int end, int precision) {
        int length = end - start;
        int startPos = 4 - length;
        byte[] output = new byte[4];
        if (startPos >= 0) {
            buffer.getBytes(start, output, startPos, length);
        } else {
            buffer.getBytes(start - startPos, output, 0, length + startPos);
            startPos = 0;
        }
        if (output[startPos] < 0) {
            Arrays.fill(output, 0, output.length - length, (byte)-1);
        }
        consumer.addInteger(Ints.fromByteArray(output));
    }
}

