/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.decimal;

import io.netty.buffer.DrillBuf;
import java.util.Arrays;
import org.apache.drill.exec.store.parquet.decimal.DecimalValueWriter;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

public class FixedLenDecimalParquetValueWriter
extends DecimalValueWriter {
    @Override
    public void writeValue(RecordConsumer consumer, DrillBuf buffer, int start, int end, int precision) {
        int typeLength = DecimalUtility.getMaxBytesSizeForPrecision(precision);
        int length = end - start;
        int startPos = typeLength - length;
        byte[] output = new byte[typeLength];
        if (startPos >= 0) {
            buffer.getBytes(start, output, startPos, length);
            if (output[startPos] < 0) {
                Arrays.fill(output, 0, output.length - length, (byte)-1);
            }
        } else {
            buffer.getBytes(start - startPos, output, 0, length + startPos);
        }
        consumer.addBinary(Binary.fromReusedByteArray((byte[])output));
    }
}

