/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.decimal;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.store.parquet.decimal.BinaryDecimalParquetValueWriter;
import org.apache.drill.exec.store.parquet.decimal.FixedLenDecimalParquetValueWriter;
import org.apache.drill.exec.store.parquet.decimal.Int32DecimalParquetValueWriter;
import org.apache.drill.exec.store.parquet.decimal.Int64DecimalParquetValueWriter;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.PrimitiveType;

public abstract class DecimalValueWriter {
    public abstract void writeValue(RecordConsumer var1, DrillBuf var2, int var3, int var4, int var5);

    public static DecimalValueWriter getDecimalValueWriterForType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT32: {
                return new Int32DecimalParquetValueWriter();
            }
            case INT64: {
                return new Int64DecimalParquetValueWriter();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new FixedLenDecimalParquetValueWriter();
            }
            case BINARY: {
                return new BinaryDecimalParquetValueWriter();
            }
        }
        throw new UnsupportedOperationException(String.format("Specified PrimitiveTypeName %s cannot be used to store decimal values", type));
    }
}

