/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.compression;

import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.drill.exec.store.parquet.compression.AirliftBytesInputCompressor;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillCompressionCodecFactory
implements CompressionCodecFactory {
    private static final Logger logger = LoggerFactory.getLogger(DrillCompressionCodecFactory.class);
    private static final Set<CompressionCodecName> AIRCOMPRESSOR_CODECS = EnumSet.of(CompressionCodecName.LZ4, CompressionCodecName.LZO, CompressionCodecName.SNAPPY, CompressionCodecName.ZSTD);
    private final Map<CompressionCodecName, AirliftBytesInputCompressor> airCompressors = new HashMap<CompressionCodecName, AirliftBytesInputCompressor>();
    private final ByteBufferAllocator allocator;
    private final Deque<CompressionCodecFactory> singleUseFactories;
    private final Configuration config;
    private final int pageSize;

    public static CompressionCodecFactory createDirectCodecFactory(Configuration config, ByteBufferAllocator allocator, int pageSize) {
        return new DrillCompressionCodecFactory(config, allocator, pageSize);
    }

    public DrillCompressionCodecFactory(Configuration config, ByteBufferAllocator allocator, int pageSize) {
        this.config = config;
        this.allocator = allocator;
        this.pageSize = pageSize;
        this.singleUseFactories = new LinkedList<CompressionCodecFactory>();
    }

    public synchronized CompressionCodecFactory.BytesInputCompressor getCompressor(CompressionCodecName codecName) {
        if (AIRCOMPRESSOR_CODECS.contains(codecName)) {
            return this.airCompressors.computeIfAbsent(codecName, c -> new AirliftBytesInputCompressor(codecName, this.allocator));
        }
        CodecFactory ccf = CodecFactory.createDirectCodecFactory((Configuration)this.config, (ByteBufferAllocator)this.allocator, (int)this.pageSize);
        this.singleUseFactories.add((CompressionCodecFactory)ccf);
        return ccf.getCompressor(codecName);
    }

    public synchronized CompressionCodecFactory.BytesInputDecompressor getDecompressor(CompressionCodecName codecName) {
        if (AIRCOMPRESSOR_CODECS.contains(codecName)) {
            return this.airCompressors.computeIfAbsent(codecName, c -> new AirliftBytesInputCompressor(codecName, this.allocator));
        }
        CodecFactory ccf = CodecFactory.createDirectCodecFactory((Configuration)this.config, (ByteBufferAllocator)this.allocator, (int)this.pageSize);
        this.singleUseFactories.add((CompressionCodecFactory)ccf);
        return ccf.getDecompressor(codecName);
    }

    public synchronized void release() {
        this.airCompressors.values().forEach(AirliftBytesInputCompressor::release);
        logger.debug("released {} aircompressors", (Object)this.airCompressors.size());
        this.airCompressors.clear();
        this.singleUseFactories.forEach(CompressionCodecFactory::release);
        logger.debug("released {} single-use codec factories.", (Object)this.singleUseFactories.size());
        this.singleUseFactories.clear();
    }
}

