/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.columnreaders.NullableVarLengthValuesColumn;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.exec.store.parquet.columnreaders.VarLengthValuesColumn;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.VarDecimalVector;
import org.apache.drill.exec.vector.VarLenBulkEntry;
import org.apache.drill.exec.vector.VarLenBulkInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarLengthColumnReaders {
    static final Logger logger = LoggerFactory.getLogger(VarLengthColumnReaders.class);

    public static final class NullableVarBinaryColumn
    extends NullableVarLengthValuesColumn<NullableVarBinaryVector> {
        private final NullableVarBinaryVector nullableVarBinaryVector;
        private final NullableVarBinaryVector.Mutator mutator;

        NullableVarBinaryColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableVarBinaryVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.nullableVarBinaryVector = v;
            this.mutator = v.getMutator();
        }

        @Override
        public boolean setSafe(int index, DrillBuf value, int start, int length) {
            if (index >= this.nullableVarBinaryVector.getValueCapacity()) {
                return false;
            }
            if (this.recordsRequireDecoding()) {
                ByteBuffer buf = this.currDecodedValToWrite.toByteBuffer();
                this.mutator.setSafe(index, buf, buf.position(), this.currDecodedValToWrite.length());
            } else {
                this.mutator.setSafe(index, 1, start, start + length, value);
            }
            return true;
        }

        @Override
        public int capacity() {
            return this.nullableVarBinaryVector.getBuffer().capacity();
        }

        @Override
        protected void setSafe(VarLenBulkInput<VarLenBulkEntry> bulkInput) {
            this.mutator.setSafe(bulkInput);
        }

        @Override
        protected VarLenColumnBulkInput<NullableVarBinaryVector> newVLBulkInput(int recordsToRead) throws IOException {
            return new VarLenColumnBulkInput<NullableVarBinaryVector>(this, recordsToRead, this.bulkReaderState);
        }
    }

    public static final class VarBinaryColumn
    extends VarLengthValuesColumn<VarBinaryVector> {
        private final VarBinaryVector varBinaryVector;
        private final VarBinaryVector.Mutator mutator;

        VarBinaryColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, VarBinaryVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.varBinaryVector = v;
            this.mutator = v.getMutator();
        }

        @Override
        public final boolean setSafe(int index, DrillBuf value, int start, int length) {
            if (index >= this.varBinaryVector.getValueCapacity()) {
                return false;
            }
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.currDecodedValToWrite = valReader.readBytes();
                ByteBuffer buf = this.currDecodedValToWrite.toByteBuffer();
                this.mutator.setSafe(index, buf, buf.position(), this.currDecodedValToWrite.length());
            } else {
                this.mutator.setSafe(index, start, start + length, value);
            }
            return true;
        }

        @Override
        public int capacity() {
            return this.varBinaryVector.getBuffer().capacity();
        }

        @Override
        protected void setSafe(VarLenBulkInput<VarLenBulkEntry> bulkInput) {
            this.mutator.setSafe(bulkInput);
        }

        @Override
        protected VarLenColumnBulkInput<VarBinaryVector> newVLBulkInput(int recordsToRead) throws IOException {
            return new VarLenColumnBulkInput<VarBinaryVector>(this, recordsToRead, this.bulkReaderState);
        }
    }

    public static final class NullableVarCharColumn
    extends NullableVarLengthValuesColumn<NullableVarCharVector> {
        protected final NullableVarCharVector.Mutator mutator;
        private final NullableVarCharVector vector;

        NullableVarCharColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableVarCharVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.vector = v;
            this.mutator = this.vector.getMutator();
        }

        @Override
        public boolean setSafe(int index, DrillBuf value, int start, int length) {
            if (index >= this.vector.getValueCapacity()) {
                return false;
            }
            if (this.recordsRequireDecoding()) {
                ByteBuffer buf = this.currDecodedValToWrite.toByteBuffer();
                this.mutator.setSafe(index, buf, buf.position(), this.currDecodedValToWrite.length());
            } else {
                this.mutator.setSafe(index, 1, start, start + length, value);
            }
            return true;
        }

        @Override
        public int capacity() {
            return this.vector.getBuffer().capacity();
        }

        @Override
        protected void setSafe(VarLenBulkInput<VarLenBulkEntry> bulkInput) {
            this.mutator.setSafe(bulkInput);
        }

        @Override
        protected VarLenColumnBulkInput<NullableVarCharVector> newVLBulkInput(int recordsToRead) throws IOException {
            return new VarLenColumnBulkInput<NullableVarCharVector>(this, recordsToRead, this.bulkReaderState);
        }
    }

    public static final class VarCharColumn
    extends VarLengthValuesColumn<VarCharVector> {
        private final VarCharVector.Mutator mutator;
        private final VarCharVector varCharVector;

        VarCharColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, VarCharVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.varCharVector = v;
            this.mutator = v.getMutator();
        }

        @Override
        public boolean setSafe(int index, DrillBuf bytebuf, int start, int length) {
            if (index >= this.varCharVector.getValueCapacity()) {
                return false;
            }
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.currDecodedValToWrite = valReader.readBytes();
                ByteBuffer buf = this.currDecodedValToWrite.toByteBuffer();
                this.mutator.setSafe(index, buf, buf.position(), this.currDecodedValToWrite.length());
            } else {
                this.mutator.setSafe(index, start, start + length, bytebuf);
            }
            return true;
        }

        @Override
        public int capacity() {
            return this.varCharVector.getBuffer().capacity();
        }

        @Override
        protected void setSafe(VarLenBulkInput<VarLenBulkEntry> bulkInput) {
            this.mutator.setSafe(bulkInput);
        }

        @Override
        protected VarLenColumnBulkInput<VarCharVector> newVLBulkInput(int recordsToRead) throws IOException {
            return new VarLenColumnBulkInput<VarCharVector>(this, recordsToRead, this.bulkReaderState);
        }
    }

    public static class NullableVarDecimalColumn
    extends NullableVarLengthValuesColumn<NullableVarDecimalVector> {
        protected NullableVarDecimalVector nullableVarDecimalVector;
        protected NullableVarDecimalVector.Mutator mutator;

        NullableVarDecimalColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableVarDecimalVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.nullableVarDecimalVector = v;
            this.mutator = v.getMutator();
        }

        @Override
        public boolean setSafe(int index, DrillBuf value, int start, int length) {
            if (index >= this.nullableVarDecimalVector.getValueCapacity()) {
                return false;
            }
            if (this.recordsRequireDecoding()) {
                ByteBuffer buf = this.currDecodedValToWrite.toByteBuffer();
                this.mutator.setSafe(index, buf, buf.position(), this.currDecodedValToWrite.length());
            } else {
                this.mutator.setSafe(index, 1, start, start + length, value);
            }
            return true;
        }

        @Override
        public int capacity() {
            return this.nullableVarDecimalVector.getBuffer().capacity();
        }

        @Override
        protected void setSafe(VarLenBulkInput<VarLenBulkEntry> bulkInput) {
            this.mutator.setSafe(bulkInput);
        }

        @Override
        protected VarLenColumnBulkInput<NullableVarDecimalVector> newVLBulkInput(int recordsToRead) throws IOException {
            return new VarLenColumnBulkInput<NullableVarDecimalVector>(this, recordsToRead, this.bulkReaderState);
        }
    }

    public static class VarDecimalColumn
    extends VarLengthValuesColumn<VarDecimalVector> {
        protected VarDecimalVector varDecimalVector;
        protected VarDecimalVector.Mutator mutator;

        VarDecimalColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, VarDecimalVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.varDecimalVector = v;
            this.mutator = v.getMutator();
        }

        @Override
        public boolean setSafe(int index, DrillBuf value, int start, int length) {
            if (index >= this.varDecimalVector.getValueCapacity()) {
                return false;
            }
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.currDecodedValToWrite = valReader.readBytes();
                ByteBuffer buf = this.currDecodedValToWrite.toByteBuffer();
                this.mutator.setSafe(index, buf, buf.position(), this.currDecodedValToWrite.length());
            } else {
                this.mutator.setSafe(index, start, start + length, value);
            }
            return true;
        }

        @Override
        public int capacity() {
            return this.varDecimalVector.getBuffer().capacity();
        }

        @Override
        protected void setSafe(VarLenBulkInput<VarLenBulkEntry> bulkInput) {
            this.mutator.setSafe(bulkInput);
        }

        @Override
        protected VarLenColumnBulkInput<VarDecimalVector> newVLBulkInput(int recordsToRead) throws IOException {
            return new VarLenColumnBulkInput<VarDecimalVector>(this, recordsToRead, this.bulkReaderState);
        }
    }
}

