/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.nio.ByteBuffer;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchOverflow;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchSizerManager;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public final class VarLenOverflowReader
extends VarLenAbstractEntryReader {
    private final RecordBatchSizerManager.FieldOverflowStateContainer fieldOverflowContainer;
    private final boolean isNullable;
    private final FieldOverflowStateImpl overflowState;

    VarLenOverflowReader(ByteBuffer buffer, VarLenColumnBulkEntry entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback, RecordBatchSizerManager.FieldOverflowStateContainer fieldOverflowContainer) {
        super(buffer, entry, containerCallback);
        this.fieldOverflowContainer = fieldOverflowContainer;
        this.isNullable = fieldOverflowContainer.overflowDef.field.isNullable();
        this.initOverflowStateIfNeeded();
        this.overflowState = (FieldOverflowStateImpl)fieldOverflowContainer.overflowState;
    }

    @Override
    VarLenColumnBulkEntry getEntry(int valuesToRead) {
        int dataLen;
        if (this.getRemainingOverflowData() == 0) {
            return null;
        }
        int[] valueLengths = this.entry.getValuesLength();
        RecordBatchOverflow.FieldOverflowDefinition overflowDef = this.fieldOverflowContainer.overflowDef;
        OverflowDataCache overflowDataCache = this.overflowState.overflowDataCache;
        int maxDataSize = 4096;
        if (this.overflowState.currValueIdx == this.overflowState.numCommittedValues) {
            overflowDataCache.flush();
        }
        int maxValues = Math.min(this.entry.getMaxEntries(), valuesToRead);
        int numAvailableValues = overflowDataCache.load(this.overflowState.currValueIdx, maxValues);
        Preconditions.checkState(numAvailableValues > 0, "Number values to read [%s] should be greater than zero", numAvailableValues);
        int firstValueDataOffset = this.getDataBufferStartOffset() + this.adjustDataOffset(this.overflowState.currValueIdx);
        int totalDataLen = 0;
        int currValueIdx = this.overflowState.currValueIdx;
        int idx = 0;
        int numNulls = 0;
        while (idx < numAvailableValues) {
            if (!this.isNullable || overflowDataCache.getNullable(currValueIdx) == 1) {
                dataLen = overflowDataCache.getDataLength(currValueIdx);
                if (totalDataLen + dataLen > 4096) break;
                totalDataLen += dataLen;
                valueLengths[idx] = dataLen;
            } else {
                valueLengths[idx] = -1;
                ++numNulls;
            }
            ++idx;
            ++currValueIdx;
        }
        if (idx == 0) {
            dataLen = overflowDataCache.getDataLength(currValueIdx);
            return this.handleLargeEntry(4096, firstValueDataOffset, dataLen);
        }
        this.overflowState.currValueIdx = currValueIdx;
        this.entry.set(firstValueDataOffset, totalDataLen, idx, idx - numNulls, overflowDef.buffer);
        return this.entry;
    }

    int getRemainingOverflowData() {
        return this.overflowState.getRemainingOverflowData();
    }

    private VarLenColumnBulkEntry handleLargeEntry(int maxDataSize, int firstValueDataOffset, int totalDataLen) {
        RecordBatchOverflow.FieldOverflowDefinition overflowDef = this.fieldOverflowContainer.overflowDef;
        FieldOverflowStateImpl overflowState = (FieldOverflowStateImpl)this.fieldOverflowContainer.overflowState;
        int[] valueLengths = this.entry.getValuesLength();
        if (this.batchMemoryConstraintsReached(this.isNullable ? 1 : 0, 4, totalDataLen)) {
            this.entry.set(0, 0, 0, 0);
            return this.entry;
        }
        valueLengths[0] = totalDataLen;
        this.entry.set(firstValueDataOffset, totalDataLen, 1, 1, overflowDef.buffer);
        overflowState.currValueIdx++;
        return this.entry;
    }

    void initOverflowStateIfNeeded() {
        if (this.fieldOverflowContainer.overflowState == null) {
            this.fieldOverflowContainer.overflowState = new FieldOverflowStateImpl(this.buffer, this.fieldOverflowContainer.overflowDef);
        }
    }

    private int adjustDataOffset(int valueIdx) {
        int targetOffset;
        int firstOffset;
        if (!this.isNullable) {
            firstOffset = this.fieldOverflowContainer.overflowDef.buffer.getInt(0);
            targetOffset = this.fieldOverflowContainer.overflowDef.buffer.getInt(valueIdx * 4);
        } else {
            int numOverflowValues = this.fieldOverflowContainer.overflowDef.numValues;
            firstOffset = this.fieldOverflowContainer.overflowDef.buffer.getInt(numOverflowValues);
            targetOffset = this.fieldOverflowContainer.overflowDef.buffer.getInt(numOverflowValues + valueIdx * 4);
        }
        return targetOffset - firstOffset;
    }

    private int getDataBufferStartOffset() {
        if (!this.isNullable) {
            return (this.fieldOverflowContainer.overflowDef.numValues + 1) * 4;
        }
        return this.fieldOverflowContainer.overflowDef.numValues + (this.fieldOverflowContainer.overflowDef.numValues + 1) * 4;
    }

    static final class FieldOverflowStateImpl
    implements RecordBatchSizerManager.FieldOverflowState {
        private int numCommittedValues;
        private int currValueIdx;
        private final OverflowDataCache overflowDataCache;

        private FieldOverflowStateImpl(ByteBuffer buffer, RecordBatchOverflow.FieldOverflowDefinition overflowDef) {
            this.overflowDataCache = new OverflowDataCache(buffer, overflowDef);
        }

        @Override
        public void onNewBatchValuesConsumed(int numValues) {
            if (this.numCommittedValues < ((OverflowDataCache)this.overflowDataCache).overflowDef.numValues) {
                this.numCommittedValues += numValues;
                this.currValueIdx = this.numCommittedValues;
            }
        }

        @Override
        public boolean isOverflowDataFullyConsumed() {
            return this.numCommittedValues == ((OverflowDataCache)this.overflowDataCache).overflowDef.numValues;
        }

        int getRemainingOverflowData() {
            assert (this.currValueIdx <= ((OverflowDataCache)this.overflowDataCache).overflowDef.numValues);
            return ((OverflowDataCache)this.overflowDataCache).overflowDef.numValues - this.currValueIdx;
        }
    }

    static final class OverflowDataCache {
        private static final int MAX_NUM_VALUES = 818;
        private final byte[] bufferArray;
        private final RecordBatchOverflow.FieldOverflowDefinition overflowDef;
        final boolean isNullable;
        private int firstCachedValueIdx;
        private int numCachedValues;

        private OverflowDataCache(ByteBuffer buffer, RecordBatchOverflow.FieldOverflowDefinition overflowDef) {
            this.bufferArray = buffer.array();
            this.overflowDef = overflowDef;
            this.isNullable = this.overflowDef.field.isNullable();
            this.firstCachedValueIdx = -1;
            this.numCachedValues = -1;
        }

        private void flush() {
            this.firstCachedValueIdx = -1;
            this.numCachedValues = -1;
        }

        private int load(int currentValueIdx, int maxValues) {
            if (currentValueIdx >= this.overflowDef.numValues) {
                throw new RuntimeException();
            }
            assert (currentValueIdx < this.overflowDef.numValues);
            if (this.numCachedValues > 0 && currentValueIdx >= this.lowerBound() && currentValueIdx <= this.upperBound()) {
                return this.upperBound() - currentValueIdx + 1;
            }
            this.loadInternal(currentValueIdx, maxValues);
            return this.numCachedValues;
        }

        private int lowerBound() {
            return this.firstCachedValueIdx;
        }

        private int upperBound() {
            return this.firstCachedValueIdx + this.numCachedValues - 1;
        }

        private byte getNullable(int valueIdx) {
            assert (this.isNullable);
            assert (valueIdx >= this.lowerBound());
            assert (valueIdx <= this.upperBound());
            int cacheIdx = (valueIdx - this.lowerBound()) * 1;
            return this.bufferArray[cacheIdx];
        }

        private int getDataLength(int valueIdx) {
            assert (valueIdx >= this.lowerBound());
            assert (valueIdx <= this.upperBound());
            int cacheIdx1 = !this.isNullable ? (valueIdx - this.lowerBound()) * 4 : this.numCachedValues + (valueIdx - this.lowerBound()) * 4;
            int cacheIdx2 = cacheIdx1 + 4;
            return VarLenOverflowReader.getInt(this.bufferArray, cacheIdx2) - VarLenOverflowReader.getInt(this.bufferArray, cacheIdx1);
        }

        private void loadInternal(int targetIdx, int maxValues) {
            this.firstCachedValueIdx = targetIdx;
            int remaining = this.remaining();
            assert (remaining > 0);
            int maxValuesToLoad = Math.min(818, maxValues);
            this.numCachedValues = Math.min(remaining, maxValuesToLoad);
            this.loadNullable();
            this.loadOffsets();
        }

        void loadNullable() {
            if (!this.isNullable) {
                return;
            }
            this.overflowDef.buffer.getBytes(this.firstCachedValueIdx, this.bufferArray, 0, this.numCachedValues);
        }

        void loadOffsets() {
            int targetIdx;
            int sourceIdx;
            if (!this.isNullable) {
                sourceIdx = this.firstCachedValueIdx * 4;
                targetIdx = 0;
            } else {
                sourceIdx = this.overflowDef.numValues + this.firstCachedValueIdx * 4;
                targetIdx = this.numCachedValues;
            }
            this.overflowDef.buffer.getBytes(sourceIdx, this.bufferArray, targetIdx, (this.numCachedValues + 1) * 4);
        }

        private int remaining() {
            return this.overflowDef.numValues - this.firstCachedValueIdx;
        }
    }
}

