/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.nio.ByteBuffer;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractPageEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

final class VarLenNullableEntryReader
extends VarLenAbstractPageEntryReader {
    VarLenNullableEntryReader(ByteBuffer buffer, VarLenColumnBulkInput.PageDataInfo pageInfo, VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo, VarLenColumnBulkEntry entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback) {
        super(buffer, pageInfo, columnPrecInfo, entry, containerCallback);
    }

    @Override
    VarLenColumnBulkEntry getEntry(int valuesToRead) {
        assert (valuesToRead > 0);
        if (this.bulkProcess()) {
            return this.getEntryBulk(valuesToRead);
        }
        return this.getEntrySingle();
    }

    VarLenColumnBulkEntry getEntryBulk(int valuesToRead) {
        this.load(true);
        int[] valueLengths = this.entry.getValuesLength();
        int readBatch = Math.min(this.entry.getMaxEntries(), valuesToRead);
        Preconditions.checkState(readBatch > 0, "Read batch count [%s] should be greater than zero", readBatch);
        byte[] tgtBuff = this.entry.getInternalDataArray();
        byte[] srcBuff = this.buffer.array();
        int srcLen = this.buffer.remaining();
        int tgtLen = tgtBuff.length;
        int numValues = 0;
        int numNulls = 0;
        int tgtPos = 0;
        int srcPos = 0;
        this.pageInfo.definitionLevels.readFirstIntegerIfNeeded();
        while (numValues < readBatch) {
            if (this.pageInfo.definitionLevels.readCurrInteger() == 1) {
                int dataLen;
                if (srcPos > srcLen - 4 || srcLen < (srcPos += 4) + (dataLen = VarLenNullableEntryReader.getInt(srcBuff, srcPos)) || tgtLen < tgtPos + dataLen) break;
                valueLengths[numValues++] = dataLen;
                if (dataLen > 0) {
                    VarLenNullableEntryReader.vlCopy(srcBuff, srcPos, tgtBuff, tgtPos, dataLen);
                    srcPos += dataLen;
                    tgtPos += dataLen;
                }
            } else {
                valueLengths[numValues++] = -1;
                ++numNulls;
            }
            this.pageInfo.definitionLevels.nextIntegerIfNotEOF();
        }
        if (numValues == 0) {
            return this.getEntrySingle();
        }
        int numNonNullValues = numValues - numNulls;
        this.pageInfo.pageDataOff += numNonNullValues * 4 + tgtPos;
        if (this.remainingPageData() < 0) {
            String message = String.format("Invalid Parquet page data offset [%d]..", this.pageInfo.pageDataOff);
            throw new DrillRuntimeException(message);
        }
        this.entry.set(0, tgtPos, numValues, numNonNullValues);
        return this.entry;
    }

    VarLenColumnBulkEntry getEntrySingle() {
        this.pageInfo.definitionLevels.readFirstIntegerIfNeeded();
        int[] valueLengths = this.entry.getValuesLength();
        if (this.pageInfo.definitionLevels.readCurrInteger() == 1) {
            if (this.remainingPageData() < 4) {
                String message = String.format("Invalid Parquet page metadata; cannot process advertised page count..", new Object[0]);
                throw new DrillRuntimeException(message);
            }
            int dataLen = this.pageInfo.pageData.getInt(this.pageInfo.pageDataOff);
            if (this.remainingPageData() < 4 + dataLen) {
                String message = String.format("Invalid Parquet page metadata; cannot process advertised page count..", new Object[0]);
                throw new DrillRuntimeException(message);
            }
            if (this.batchMemoryConstraintsReached(1, 4, dataLen)) {
                this.entry.set(0, 0, 0, 0);
                return this.entry;
            }
            valueLengths[0] = dataLen;
            this.entry.set(this.pageInfo.pageDataOff + 4, dataLen, 1, 1, this.pageInfo.pageData);
            this.pageInfo.pageDataOff += dataLen + 4;
        } else {
            valueLengths[0] = -1;
            this.entry.set(0, 0, 1, 0);
        }
        this.pageInfo.definitionLevels.nextIntegerIfNotEOF();
        return this.entry;
    }
}

