/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.nio.ByteBuffer;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractPageEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.parquet.io.api.Binary;

final class VarLenNullableDictionaryReader
extends VarLenAbstractPageEntryReader {
    VarLenNullableDictionaryReader(ByteBuffer buffer, VarLenColumnBulkInput.PageDataInfo pageInfo, VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo, VarLenColumnBulkEntry entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback) {
        super(buffer, pageInfo, columnPrecInfo, entry, containerCallback);
    }

    @Override
    final VarLenColumnBulkEntry getEntry(int valuesToRead) {
        assert (valuesToRead > 0);
        if (this.bulkProcess()) {
            return this.getEntryBulk(valuesToRead);
        }
        return this.getEntrySingle();
    }

    private final VarLenColumnBulkEntry getEntryBulk(int valuesToRead) {
        VarLenColumnBulkInput.ValuesReaderWrapper valueReader = this.pageInfo.encodedValueReader;
        int[] valueLengths = this.entry.getValuesLength();
        int readBatch = Math.min(this.entry.getMaxEntries(), valuesToRead);
        Preconditions.checkState(readBatch > 0, "Read batch count [%s] should be greater than zero", readBatch);
        byte[] tgtBuff = this.entry.getInternalDataArray();
        int tgtLen = tgtBuff.length;
        int numValues = 0;
        int numNulls = 0;
        int tgtPos = 0;
        this.pageInfo.definitionLevels.readFirstIntegerIfNeeded();
        for (int idx = 0; idx < readBatch; ++idx) {
            if (this.pageInfo.definitionLevels.readCurrInteger() == 1) {
                Binary currEntry = valueReader.getEntry();
                int dataLen = currEntry.length();
                if (tgtLen < tgtPos + dataLen) {
                    valueReader.pushBack(currEntry);
                    break;
                }
                valueLengths[numValues++] = dataLen;
                if (dataLen > 0) {
                    VarLenNullableDictionaryReader.vlCopyNoPadding(currEntry.getBytes(), 0, tgtBuff, tgtPos, dataLen);
                    tgtPos += dataLen;
                }
            } else {
                valueLengths[numValues++] = -1;
                ++numNulls;
            }
            this.pageInfo.definitionLevels.nextIntegerIfNotEOF();
        }
        if (numValues == 0) {
            return this.getEntrySingle();
        }
        this.entry.set(0, tgtPos, numValues, numValues - numNulls);
        return this.entry;
    }

    private VarLenColumnBulkEntry getEntrySingle() {
        int[] valueLengths = this.entry.getValuesLength();
        VarLenColumnBulkInput.ValuesReaderWrapper valueReader = this.pageInfo.encodedValueReader;
        this.pageInfo.definitionLevels.readFirstIntegerIfNeeded();
        if (this.pageInfo.definitionLevels.readCurrInteger() == 1) {
            Binary currEntry = valueReader.getEntry();
            int dataLen = currEntry.length();
            if (this.batchMemoryConstraintsReached(1, 4, dataLen)) {
                valueReader.pushBack(currEntry);
                this.entry.set(0, 0, 0, 0);
                return this.entry;
            }
            valueLengths[0] = dataLen;
            this.entry.set(0, dataLen, 1, 1, currEntry.getBytes());
        } else {
            valueLengths[0] = -1;
            this.entry.set(0, 0, 1, 0);
        }
        this.pageInfo.definitionLevels.nextIntegerIfNotEOF();
        return this.entry;
    }
}

