/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.nio.ByteBuffer;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractPageEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

final class VarLenEntryReader
extends VarLenAbstractPageEntryReader {
    VarLenEntryReader(ByteBuffer buffer, VarLenColumnBulkInput.PageDataInfo pageInfo, VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo, VarLenColumnBulkEntry entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback) {
        super(buffer, pageInfo, columnPrecInfo, entry, containerCallback);
    }

    @Override
    VarLenColumnBulkEntry getEntry(int valuesToRead) {
        if (this.bulkProcess()) {
            return this.getEntryBulk(valuesToRead);
        }
        return this.getEntrySingle();
    }

    private final VarLenColumnBulkEntry getEntryBulk(int valuesToRead) {
        int dataLen;
        this.load(true);
        int[] valueLengths = this.entry.getValuesLength();
        int readBatch = Math.min(this.entry.getMaxEntries(), valuesToRead);
        Preconditions.checkState(readBatch > 0, "Read batch count [%s] should be greater than zero", readBatch);
        byte[] tgtBuff = this.entry.getInternalDataArray();
        byte[] srcBuff = this.buffer.array();
        int srcLen = this.buffer.remaining();
        int tgtLen = tgtBuff.length;
        int numValues = 0;
        int tgtPos = 0;
        int srcPos = 0;
        while (numValues < readBatch && srcPos <= srcLen - 4 && srcLen >= (srcPos += 4) + (dataLen = VarLenEntryReader.getInt(srcBuff, srcPos)) && tgtLen >= tgtPos + dataLen) {
            valueLengths[numValues++] = dataLen;
            if (dataLen <= 0) continue;
            VarLenEntryReader.vlCopy(srcBuff, srcPos, tgtBuff, tgtPos, dataLen);
            srcPos += dataLen;
            tgtPos += dataLen;
        }
        if (numValues == 0) {
            return this.getEntrySingle();
        }
        this.pageInfo.pageDataOff += numValues * 4 + tgtPos;
        if (this.remainingPageData() < 0) {
            String message = String.format("Invalid Parquet page data offset [%d]..", this.pageInfo.pageDataOff);
            throw new DrillRuntimeException(message);
        }
        this.entry.set(0, tgtPos, numValues, numValues);
        return this.entry;
    }

    private VarLenColumnBulkEntry getEntrySingle() {
        if (this.remainingPageData() < 4) {
            String message = String.format("Invalid Parquet page metadata; cannot process advertised page count..", new Object[0]);
            throw new DrillRuntimeException(message);
        }
        int[] valueLengths = this.entry.getValuesLength();
        int dataLen = this.pageInfo.pageData.getInt(this.pageInfo.pageDataOff);
        if (this.remainingPageData() < 4 + dataLen) {
            String message = String.format("Invalid Parquet page metadata; cannot process advertised page count..", new Object[0]);
            throw new DrillRuntimeException(message);
        }
        if (this.batchMemoryConstraintsReached(0, 4, dataLen)) {
            this.entry.set(0, 0, 0, 0);
            return this.entry;
        }
        valueLengths[0] = dataLen;
        this.entry.set(this.pageInfo.pageDataOff + 4, dataLen, 1, 1, this.pageInfo.pageData);
        this.pageInfo.pageDataOff += dataLen + 4;
        return this.entry;
    }
}

