/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.parquet.columnreaders.PageReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenBulkPageReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenOverflowReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLengthValuesColumn;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.BatchSizingMemoryUtil;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchSizerManager;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarLenBulkEntry;
import org.apache.drill.exec.vector.VarLenBulkInput;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarLenColumnBulkInput<V extends ValueVector>
implements VarLenBulkInput<VarLenBulkEntry> {
    private static final Logger logger = LoggerFactory.getLogger(VarLenColumnBulkInput.class);
    private static final int BULK_PROCESSING_MAX_PREC_LEN = 1024;
    private final VarLengthValuesColumn<V> parentInst;
    private final RecordBatchSizerManager batchSizerMgr;
    private final ColumnPrecisionInfo columnPrecInfo;
    private final DefLevelReaderWrapper custDefLevelReader;
    private final ValuesReaderWrapper custValuesReader;
    private final int recordsToRead;
    private RecordBatchSizerManager.ColumnMemoryQuota columnMemoryQuota;
    private final OprBulkReadState oprReadState;
    private final PageDataInfo pageInfo = new PageDataInfo();
    private VarLenBulkPageReader buffPagePayload;
    private final VarLenColumnBulkInputCallback callback;
    private final BatchSizingMemoryUtil.ColumnMemoryUsageInfo columnMemoryUsage = new BatchSizingMemoryUtil.ColumnMemoryUsageInfo();
    private RecordBatchSizerManager.FieldOverflowStateContainer fieldOverflowStateContainer;

    VarLenColumnBulkInput(VarLengthValuesColumn<V> parentInst, int recordsToRead, BulkReaderState bulkReaderState) throws IOException {
        this.parentInst = parentInst;
        this.batchSizerMgr = this.parentInst.parentReader.getBatchSizesMgr();
        this.recordsToRead = recordsToRead;
        this.callback = new VarLenColumnBulkInputCallback(this);
        this.columnPrecInfo = bulkReaderState.columnPrecInfo;
        this.custDefLevelReader = bulkReaderState.definitionLevelReader;
        this.custValuesReader = bulkReaderState.encodedValuesReader;
        this.fieldOverflowStateContainer = this.batchSizerMgr.getFieldOverflowContainer(parentInst.valueVec.getField().getName());
        this.loadPageIfNeed();
        this.oprReadState = new OprBulkReadState(parentInst.pageReader.readyToReadPosInBytes, parentInst.pageReader.valuesRead);
        if (ColumnPrecisionType.isPrecTypeUnknown(this.columnPrecInfo.columnPrecisionType)) {
            this.guessColumnPrecision(this.columnPrecInfo);
        }
        this.setBufferedPagePayload();
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.batchConstraintsReached()) {
                if (!(this.overflowDataAvailable() || this.parentInst.pageReader.hasPage() && this.parentInst.pageReader.pageValueCount != this.oprReadState.numPageFieldsProcessed)) {
                    long totalValueCount = this.parentInst.columnChunkMetaData.getValueCount();
                    if (totalValueCount == (long)(this.parentInst.totalValuesRead + this.oprReadState.batchNumValuesReadFromPages) || !this.parentInst.pageReader.next()) {
                        this.parentInst.hitRowGroupEnd();
                        return false;
                    }
                    this.oprReadState.numPageFieldsProcessed = 0;
                    this.oprReadState.pageReadPos = this.parentInst.pageReader.readyToReadPosInBytes;
                    this.setValuesReadersOnNewPage();
                    this.setBufferedPagePayload();
                }
                return true;
            }
            return false;
        }
        catch (IOException ie) {
            throw new DrillRuntimeException(ie);
        }
    }

    @Override
    public final VarLenBulkEntry next() {
        int remaining = this.getRemainingRecords();
        VarLenColumnBulkEntry result = this.buffPagePayload.getEntry(remaining);
        if (result != null && result.getNumValues() > 0) {
            if (result.isReadFromPage()) {
                if (!this.pageInfo.encodedValueReader.isDefined()) {
                    this.oprReadState.pageReadPos += (long)(result.getTotalLength() + 4 * result.getNumNonNullValues());
                }
                this.oprReadState.numPageFieldsProcessed += result.getNumValues();
                this.oprReadState.batchNumValuesReadFromPages += result.getNumValues();
            }
            this.oprReadState.batchFieldIndex += result.getNumValues();
        }
        return result;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getStartIndex() {
        return this.oprReadState.batchFieldIndex;
    }

    @Override
    public final void done() {
        if (this.pageInfo.encodedValueReader == null || !this.pageInfo.encodedValueReader.isDefined()) {
            this.parentInst.pageReader.readyToReadPosInBytes = this.oprReadState.pageReadPos;
        }
        this.parentInst.pageReader.valuesRead = this.oprReadState.numPageFieldsProcessed;
        this.parentInst.totalValuesRead += this.oprReadState.batchNumValuesReadFromPages;
        if (logger.isDebugEnabled()) {
            String message = String.format("requested=%d, returned=%d, total-returned=%d", this.recordsToRead, this.oprReadState.batchFieldIndex, this.parentInst.totalValuesRead);
            logger.debug(message);
        }
    }

    public static int getMinVLColumnMemorySize() {
        return 8192;
    }

    final int getReadBatchFields() {
        return this.oprReadState.batchFieldIndex;
    }

    private final void setValuesReadersOnNewPage() {
        PageReader pageReader = this.parentInst.pageReader;
        if (pageReader.pageValueCount > 0) {
            this.custDefLevelReader.set(pageReader.definitionLevels, pageReader.pageValueCount);
            if (this.parentInst.recordsRequireDecoding()) {
                this.custValuesReader.set(this.parentInst.usingDictionary ? pageReader.getDictionaryValueReader() : pageReader.getValueReader());
            } else {
                this.custValuesReader.set(null);
            }
        } else {
            this.custDefLevelReader.set(null, 0);
            this.custValuesReader.set(null);
        }
    }

    private final void setBufferedPagePayload() {
        if (this.parentInst.pageReader.hasPage() && this.oprReadState.numPageFieldsProcessed < this.parentInst.pageReader.pageValueCount) {
            if (!this.parentInst.usingDictionary) {
                this.pageInfo.pageData = this.parentInst.pageReader.pageData;
                this.pageInfo.pageDataOff = (int)this.oprReadState.pageReadPos;
                this.pageInfo.pageDataLen = this.parentInst.pageReader.byteLength;
            }
            this.pageInfo.numPageValues = this.parentInst.pageReader.pageValueCount;
            this.pageInfo.definitionLevels = this.custDefLevelReader;
            this.pageInfo.encodedValueReader = this.custValuesReader;
            this.pageInfo.numPageFieldsRead = this.oprReadState.numPageFieldsProcessed;
            if (this.buffPagePayload == null) {
                this.buffPagePayload = new VarLenBulkPageReader(this.pageInfo, this.columnPrecInfo, this.callback, this.fieldOverflowStateContainer);
            } else {
                this.buffPagePayload.set(this.pageInfo, true);
            }
        } else if (this.buffPagePayload == null) {
            this.buffPagePayload = new VarLenBulkPageReader(null, this.columnPrecInfo, this.callback, this.fieldOverflowStateContainer);
        }
    }

    final ColumnPrecisionInfo getColumnPrecisionInfo() {
        return this.columnPrecInfo;
    }

    private final void guessColumnPrecision(ColumnPrecisionInfo columnPrecInfo) throws IOException {
        columnPrecInfo.columnPrecisionType = ColumnPrecisionType.DT_PRECISION_IS_VARIABLE;
        this.loadPageIfNeed();
        int minNumVals = 4;
        int maxDataToProcess = Math.min(4112, (int)((long)this.parentInst.pageReader.byteLength - this.parentInst.pageReader.readyToReadPosInBytes));
        if (this.parentInst.recordsRequireDecoding() || maxDataToProcess == 0) {
            columnPrecInfo.bulkProcess = true;
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(maxDataToProcess);
        buffer.order(ByteOrder.nativeOrder());
        this.parentInst.pageReader.pageData.getBytes((int)this.parentInst.pageReader.readyToReadPosInBytes, buffer.array(), 0, maxDataToProcess);
        buffer.limit(maxDataToProcess);
        int numValues = 0;
        int fixedDataLen = -1;
        boolean isFixedPrecision = false;
        while (buffer.remaining() >= 4) {
            int data_len = buffer.getInt();
            if (fixedDataLen < 0) {
                fixedDataLen = data_len;
                isFixedPrecision = true;
            }
            if (isFixedPrecision && fixedDataLen != data_len) {
                isFixedPrecision = false;
            }
            if (buffer.remaining() < data_len) break;
            buffer.position(buffer.position() + data_len);
            ++numValues;
        }
        if (isFixedPrecision && fixedDataLen >= 0) {
            columnPrecInfo.columnPrecisionType = ColumnPrecisionType.DT_PRECISION_IS_FIXED;
            columnPrecInfo.precision = fixedDataLen;
            if (fixedDataLen <= 1024) {
                columnPrecInfo.bulkProcess = true;
            } else {
                columnPrecInfo.columnPrecisionType = ColumnPrecisionType.DT_PRECISION_IS_VARIABLE;
                columnPrecInfo.bulkProcess = false;
            }
        } else {
            columnPrecInfo.bulkProcess = numValues >= 4;
        }
    }

    private void loadPageIfNeed() throws IOException {
        if (!this.parentInst.pageReader.hasPage()) {
            this.parentInst.pageReader.next();
            this.setValuesReadersOnNewPage();
        }
    }

    private boolean batchConstraintsReached() {
        this.columnMemoryQuota = this.batchSizerMgr.getCurrentFieldBatchMemory(this.parentInst.valueVec.getField().getName());
        assert (this.columnMemoryQuota.getMaxMemoryUsage() > 0L);
        int maxNumRecordsInChunk = 1024;
        if (this.parentInst.valueVec.getField().isNullable()) {
            return this.batchConstraintsReached(1024, 4096, 4096);
        }
        return this.batchConstraintsReached(0, 4096, 4096);
    }

    private boolean batchConstraintsReached(int newBitsMemory, int newOffsetsMemory, int newDataMemory) {
        assert (this.oprReadState.batchFieldIndex <= this.recordsToRead);
        if (this.oprReadState.batchFieldIndex == this.recordsToRead) {
            return true;
        }
        if (this.oprReadState.batchFieldIndex == 0) {
            return false;
        }
        this.columnMemoryUsage.vector = this.parentInst.valueVec;
        this.columnMemoryUsage.memoryQuota = this.columnMemoryQuota;
        this.columnMemoryUsage.currValueCount = this.oprReadState.batchFieldIndex;
        return !BatchSizingMemoryUtil.canAddNewData(this.columnMemoryUsage, newBitsMemory, newOffsetsMemory, newDataMemory);
    }

    private int getRemainingRecords() {
        int remaining;
        int toReadRemaining = this.recordsToRead - this.oprReadState.batchFieldIndex;
        int remainingOverflowData = this.getRemainingOverflowData();
        if (remainingOverflowData == 0) {
            int pageRemaining = this.parentInst.pageReader.pageValueCount - this.oprReadState.numPageFieldsProcessed;
            remaining = Math.min(toReadRemaining, pageRemaining);
        } else {
            remaining = Math.min(toReadRemaining, remainingOverflowData);
        }
        return remaining;
    }

    private boolean overflowDataAvailable() {
        return this.getRemainingOverflowData() > 0;
    }

    private int getRemainingOverflowData() {
        if (this.fieldOverflowStateContainer != null) {
            VarLenOverflowReader.FieldOverflowStateImpl overflowState = (VarLenOverflowReader.FieldOverflowStateImpl)this.fieldOverflowStateContainer.overflowState;
            if (overflowState != null) {
                return overflowState.getRemainingOverflowData();
            }
            return this.fieldOverflowStateContainer.overflowDef.numValues;
        }
        return 0;
    }

    private void deinitOverflowData() {
        this.batchSizerMgr.releaseFieldOverflowContainer(this.parentInst.valueVec.getField().getName());
        this.fieldOverflowStateContainer = null;
    }

    static final class PageDataInfo {
        int numPageValues;
        DrillBuf pageData;
        int pageDataOff;
        int pageDataLen;
        int numPageFieldsRead;
        DefLevelReaderWrapper definitionLevels;
        ValuesReaderWrapper encodedValueReader;

        PageDataInfo() {
        }
    }

    static final class VarLenColumnBulkInputCallback {
        final VarLenColumnBulkInput<? extends ValueVector> parentInst;
        PageReader pageReader;

        VarLenColumnBulkInputCallback(VarLenColumnBulkInput<? extends ValueVector> parentInst) {
            this.parentInst = parentInst;
            this.pageReader = ((VarLenColumnBulkInput)this.parentInst).parentInst.pageReader;
        }

        void resetDefinitionLevelReader(int skipCount) throws IOException {
            this.pageReader.resetDefinitionLevelReader(skipCount);
        }

        PageReader.IntIterator getDefinitionLevelsReader() {
            return this.pageReader.definitionLevels;
        }

        boolean batchMemoryConstraintsReached(int newBitsMemory, int newOffsetsMemory, int newDataMemory) {
            return ((VarLenColumnBulkInput)this.parentInst).batchConstraintsReached(newBitsMemory, newOffsetsMemory, newDataMemory);
        }

        void deinitOverflowData() {
            ((VarLenColumnBulkInput)this.parentInst).deinitOverflowData();
        }
    }

    static final class BulkReaderState {
        final ColumnPrecisionInfo columnPrecInfo = new ColumnPrecisionInfo();
        final DefLevelReaderWrapper definitionLevelReader = new DefLevelReaderWrapper();
        final ValuesReaderWrapper encodedValuesReader = new ValuesReaderWrapper();

        BulkReaderState() {
        }
    }

    static final class ColumnPrecisionInfo {
        ColumnPrecisionType columnPrecisionType = ColumnPrecisionType.DT_PRECISION_UNKNOWN;
        int precision;
        boolean bulkProcess;

        ColumnPrecisionInfo() {
        }

        void clone(ColumnPrecisionInfo src) {
            this.columnPrecisionType = src.columnPrecisionType;
            this.precision = src.precision;
            this.bulkProcess = src.bulkProcess;
        }
    }

    static final class DefLevelReaderWrapper {
        private PageReader.IntIterator definitionLevels;
        private int currValue;
        private int remaining;

        DefLevelReaderWrapper() {
        }

        public boolean hasDefinitionLevels() {
            return this.definitionLevels != null;
        }

        public void readFirstIntegerIfNeeded() {
            assert (this.definitionLevels != null);
            if (this.currValue == -1) {
                this.setNextInteger();
            }
        }

        void set(PageReader.IntIterator definitionLevels, int numValues) {
            this.definitionLevels = definitionLevels;
            this.currValue = -1;
            this.remaining = numValues;
        }

        public int readCurrInteger() {
            assert (this.currValue >= 0);
            return this.currValue;
        }

        public boolean nextIntegerIfNotEOF() {
            return this.setNextInteger();
        }

        public PageReader.IntIterator getUnderlyingReader() {
            this.currValue = -1;
            return this.definitionLevels;
        }

        private boolean setNextInteger() {
            if (this.remaining > 0) {
                --this.remaining;
                try {
                    this.currValue = this.definitionLevels.nextInt();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
            this.currValue = -1;
            return false;
        }
    }

    static final class ValuesReaderWrapper {
        private ValuesReader valuesReader;
        private Binary pushedBackValue;

        ValuesReaderWrapper() {
        }

        public boolean isDefined() {
            return this.valuesReader != null;
        }

        void set(ValuesReader _rawReader) {
            this.valuesReader = _rawReader;
            this.pushedBackValue = null;
        }

        public Binary getEntry() {
            Binary entry = null;
            if (this.pushedBackValue == null) {
                entry = this.getNextEntry();
            } else {
                entry = this.pushedBackValue;
                this.pushedBackValue = null;
            }
            return entry;
        }

        public void pushBack(Binary entry) {
            this.pushedBackValue = entry;
        }

        private Binary getNextEntry() {
            try {
                return this.valuesReader.readBytes();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class OprBulkReadState {
        long pageReadPos;
        int numPageFieldsProcessed;
        int batchFieldIndex;
        int batchNumValuesReadFromPages;

        OprBulkReadState(long pageReadPos, int numPageFieldsRead) {
            this.pageReadPos = pageReadPos;
            this.numPageFieldsProcessed = numPageFieldsRead;
            this.batchFieldIndex = 0;
            this.batchNumValuesReadFromPages = 0;
        }
    }

    static enum ColumnPrecisionType {
        DT_PRECISION_UNKNOWN,
        DT_PRECISION_IS_FIXED,
        DT_PRECISION_IS_VARIABLE;


        static boolean isPrecTypeUnknown(ColumnPrecisionType type) {
            return DT_PRECISION_UNKNOWN.equals((Object)type);
        }

        static boolean isPrecTypeFixed(ColumnPrecisionType type) {
            return DT_PRECISION_IS_FIXED.equals((Object)type);
        }

        static boolean isPrecTypeVariable(ColumnPrecisionType type) {
            return DT_PRECISION_IS_VARIABLE.equals((Object)type);
        }
    }
}

