/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.exec.vector.VarLenBulkEntry;

final class VarLenColumnBulkEntry
implements VarLenBulkEntry {
    private static final int PADDING = 64;
    private int startOffset;
    private int totalLength;
    private int numValues;
    private int numNonValues;
    private final int[] lengths;
    private final byte[] internalArray;
    private byte[] externalArray;
    private DrillBuf externalDrillBuf;
    private boolean arrayBacked;
    private boolean internalDataBuf;
    private boolean readFromPage;

    VarLenColumnBulkEntry(VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo) {
        this(columnPrecInfo, 4096);
    }

    VarLenColumnBulkEntry(VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo, int buffSz) {
        int maxNumValues;
        int largestDataLen = buffSz - 4;
        int lengthSz = maxNumValues = buffSz / 4;
        int dataSz = largestDataLen + 64;
        this.lengths = new int[lengthSz];
        this.internalArray = new byte[dataSz];
    }

    @Override
    public int getTotalLength() {
        return this.totalLength;
    }

    @Override
    public boolean arrayBacked() {
        return this.arrayBacked;
    }

    @Override
    public byte[] getArrayData() {
        return this.internalDataBuf ? this.internalArray : this.externalArray;
    }

    @Override
    public DrillBuf getData() {
        return this.externalDrillBuf;
    }

    @Override
    public int getDataStartOffset() {
        return this.startOffset;
    }

    @Override
    public int[] getValuesLength() {
        return this.lengths;
    }

    @Override
    public int getNumValues() {
        return this.numValues;
    }

    @Override
    public int getNumNonNullValues() {
        return this.numNonValues;
    }

    @Override
    public boolean hasNulls() {
        return this.numNonValues < this.numValues;
    }

    public byte[] getInternalDataArray() {
        return this.internalArray;
    }

    void set(int startOffset, int totalLength, int numValues, int nonNullValues) {
        this.startOffset = startOffset;
        this.totalLength = totalLength;
        this.numValues = numValues;
        this.numNonValues = nonNullValues;
        this.arrayBacked = true;
        this.internalDataBuf = true;
        this.externalArray = null;
        this.externalDrillBuf = null;
    }

    void set(int startOffset, int totalLength, int numValues, int nonNullValues, byte[] externalArray) {
        this.startOffset = startOffset;
        this.totalLength = totalLength;
        this.numValues = numValues;
        this.numNonValues = nonNullValues;
        this.arrayBacked = true;
        this.internalDataBuf = false;
        this.externalArray = externalArray;
        this.externalDrillBuf = null;
    }

    void set(int startOffset, int totalLength, int numValues, int nonNullValues, DrillBuf externalDrillBuf) {
        this.startOffset = startOffset;
        this.totalLength = totalLength;
        this.numValues = numValues;
        this.numNonValues = nonNullValues;
        this.arrayBacked = false;
        this.internalDataBuf = false;
        this.externalArray = null;
        this.externalDrillBuf = externalDrillBuf;
    }

    int getMaxEntries() {
        return this.lengths.length;
    }

    boolean isReadFromPage() {
        return this.readFromPage;
    }

    void setReadFromPage(boolean readFromPage) {
        this.readFromPage = readFromPage;
    }
}

